/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx;

import com.eva.epc.lnf.nimbuslike.NLPanelUI;
import com.eva.epc.lnf.nimbuslike.NLWindowsButtonUI;
import com.eva.epc.swingx.action.BoundAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class JXDialog
extends JDialog {
    public static final String EXECUTE_ACTION_COMMAND = "execute";
    public static final String CLOSE_ACTION_COMMAND = "\u5173\u95ed";
    public static final String UIPREFIX = "XDialog.";
    protected JComponent content;

    public JXDialog(JComponent content) {
        this.setContent(content);
    }

    public JXDialog(Frame frame, JComponent content) {
        super(frame);
        this.setContent(content);
    }

    public JXDialog(Dialog dialog, JComponent content) {
        super(dialog);
        this.setContent(content);
    }

    private void setContent(JComponent content) {
        Action contentExecuteAction;
        if (this.content != null) {
            throw new IllegalStateException("content must not be set more than once");
        }
        this.initActions();
        Action contentCloseAction = content.getActionMap().get(CLOSE_ACTION_COMMAND);
        if (contentCloseAction != null) {
            this.putAction(CLOSE_ACTION_COMMAND, contentCloseAction);
        }
        if ((contentExecuteAction = content.getActionMap().get(EXECUTE_ACTION_COMMAND)) != null) {
            this.putAction(EXECUTE_ACTION_COMMAND, contentExecuteAction);
        }
        this.content = content;
        this.build();
        this.setTitleFromContent();
    }

    protected void setTitleFromContent() {
        if (this.content == null) {
            return;
        }
        this.setTitle(this.content.getName());
    }

    private void build() {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.content, "Center");
        p.add((Component)this.createButtonPanel(), "South");
        this.content.setBorder(BorderFactory.createEmptyBorder(9, 6, 6, 6));
        this.add(p);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.content == null) {
            throw new IllegalStateException("content must be built before showing the dialog");
        }
        super.setVisible(visible);
    }

    public void doClose() {
        this.dispose();
    }

    private void initActions() {
        Action defaultAction = this.createCloseAction();
        this.putAction(CLOSE_ACTION_COMMAND, defaultAction);
        this.putAction(EXECUTE_ACTION_COMMAND, defaultAction);
    }

    private Action createCloseAction() {
        String actionName = CLOSE_ACTION_COMMAND;
        BoundAction action = new BoundAction(actionName, CLOSE_ACTION_COMMAND);
        action.registerCallback(this, "doClose");
        return action;
    }

    protected JComponent createButtonPanel() {
        JPanel panel = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        panel.setLayout(new FlowLayout(2));
        panel.setUI(new NLPanelUI());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Action executeAction = this.getAction(EXECUTE_ACTION_COMMAND);
        Action closeAction = this.getAction(CLOSE_ACTION_COMMAND);
        JButton defaultButton = new JButton(executeAction);
        defaultButton.setUI(new NLWindowsButtonUI().setNormalColor(NLWindowsButtonUI.NormalColor.green));
        defaultButton.setForeground(Color.white);
        panel.add(defaultButton);
        this.getRootPane().setDefaultButton(defaultButton);
        if (executeAction != closeAction) {
            JButton b = new JButton(closeAction);
            panel.add(b);
        }
        return panel;
    }

    private void putAction(Object key, Action action) {
        this.getRootPane().getActionMap().put(key, action);
    }

    private Action getAction(Object key) {
        return this.getRootPane().getActionMap().get(key);
    }

    public static void main(String[] args) {
        JXDialog d = new JXDialog(new JPanel());
        d.setDefaultCloseOperation(3);
        d.setVisible(true);
    }
}

