/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx;

import com.eva.epc.swingx.icon.PainterIcon;
import com.eva.epc.swingx.painter.BusyPainter;
import com.eva.epc.swingx.plaf.BasicBusyLabelUI;
import com.eva.epc.swingx.plaf.BusyLabelUI;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class JXBusyLabel
extends JLabel {
    private static final long serialVersionUID = 5979268460848257147L;
    private BusyPainter busyPainter;
    private Timer busy;
    private int delay;
    private boolean wasBusyOnNotify = false;
    public static final String uiClassID = "EBusyLabelUI";
    private Direction direction;

    public void setDirection(Direction dir) {
        this.direction = dir;
        this.getBusyPainter().setDirection(dir);
    }

    public JXBusyLabel() {
        this((Dimension)null);
    }

    public JXBusyLabel(Dimension dim) {
        BusyLabelUI ui = (BusyLabelUI)((Object)this.getUI());
        if (ui != null) {
            this.delay = ui.getDelay();
        }
        this.setPreferredSize(dim);
        this.getBusyPainter();
    }

    protected void initPainter(Dimension dim) {
        BusyPainter busyPainter = this.getBusyPainter();
        if (busyPainter != null) {
            busyPainter.setCacheable(false);
        }
        PainterIcon icon = new PainterIcon(dim);
        icon.setPainter(busyPainter);
        this.setIcon(icon);
    }

    protected BusyPainter createBusyPainter(Dimension dim) {
        BusyPainter busyPainter = null;
        BusyLabelUI ui = (BusyLabelUI)((Object)this.getUI());
        if (ui != null) {
            busyPainter = ui.getBusyPainter(dim);
        }
        return busyPainter;
    }

    public boolean isBusy() {
        return this.busy != null;
    }

    public void setBusy(boolean busy) {
        boolean old = this.isBusy();
        if (!old && busy) {
            this.startAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        } else if (old && !busy) {
            this.stopAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        }
    }

    private void startAnimation() {
        if (this.busy != null) {
            this.stopAnimation();
        }
        this.busy = new Timer(this.delay, new ActionListener(){
            BusyPainter busyPainter;
            int frame;
            {
                this.busyPainter = JXBusyLabel.this.getBusyPainter();
                this.frame = this.busyPainter.getPoints();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.frame = (this.frame + 1) % this.busyPainter.getPoints();
                this.busyPainter.setFrame(JXBusyLabel.this.direction == Direction.LEFT ? this.busyPainter.getPoints() - this.frame : this.frame);
                JXBusyLabel.this.frameChanged();
            }
        });
        this.busy.start();
    }

    private void stopAnimation() {
        if (this.busy != null) {
            this.busy.stop();
            this.getBusyPainter().setFrame(-1);
            this.repaint();
            this.busy = null;
        }
    }

    @Override
    public void removeNotify() {
        this.wasBusyOnNotify = this.isBusy();
        this.stopAnimation();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.wasBusyOnNotify) {
            this.startAnimation();
        }
    }

    protected void frameChanged() {
        this.repaint();
    }

    public final BusyPainter getBusyPainter() {
        if (this.busyPainter == null) {
            Dimension prefSize = this.getPreferredSize();
            this.busyPainter = this.createBusyPainter((Dimension)(prefSize.width == 0 && prefSize.height == 0 && !this.isPreferredSizeSet() ? null : prefSize));
            if (this.busyPainter != null) {
                if (!(this.isPreferredSizeSet() || prefSize != null && prefSize.width != 0 && prefSize.height != 0)) {
                    Rectangle rt = this.busyPainter.getTrajectory().getBounds();
                    Rectangle rp = this.busyPainter.getPointShape().getBounds();
                    int max = Math.max(rp.width, rp.height);
                    prefSize = new Dimension(rt.width + max, rt.height + max);
                }
                this.initPainter(prefSize);
            }
        }
        return this.busyPainter;
    }

    public final void setBusyPainter(BusyPainter busyPainter) {
        this.busyPainter = busyPainter;
        this.initPainter(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        int old = this.getDelay();
        this.delay = delay;
        if (old != this.getDelay()) {
            if (this.busy != null && this.busy.isRunning()) {
                this.busy.setDelay(this.getDelay());
            }
            this.firePropertyChange("delay", old, this.getDelay());
        }
    }

    @Override
    public void updateUI() {
        this.setUI((BasicBusyLabelUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        JXBusyLabel label = new JXBusyLabel(new Dimension(60, 60)){

            @Override
            public void paint(Graphics g) {
                RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHints(hints);
                super.paint((Graphics2D)g);
            }
        };
        label.setName("busyLabel");
        label.getBusyPainter().setHighlightColor(new Color(44, 61, 146).darker());
        label.getBusyPainter().setBaseColor(new Color(168, 204, 241).brighter());
        label.getBusyPainter().setTrailLength(2);
        label.getBusyPainter().setPoints(10);
        label.getBusyPainter().setPointShape(new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0));
        label.setDelay(70);
        label.setBusy(true);
        JFrame f = new JFrame("");
        JFrame.setDefaultLookAndFeelDecorated(false);
        f.getContentPane().add(label);
        f.setBounds(100, 100, 300, 400);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        label.setBusy(true);
        label.setText("\u6570\u636e\u6b63\u5728\u83b7\u53d6\u4e2d\uff0c\u8bf7\u7a0d\u5019 ...");
        label.setToolTipText("\u8bf7\u7b49\u5f85...");
        label.setVerticalTextPosition(3);
        label.setHorizontalTextPosition(0);
    }

    public static enum Direction {
        RIGHT,
        LEFT;

    }
}

