/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintGraphics;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.print.PrinterGraphics;
import java.security.AccessController;
import javax.swing.JComponent;
import sun.print.ProxyPrintGraphics;
import sun.security.action.GetPropertyAction;
import sun.swing.PrintColorUIResource;

class NLUtils {
    private static final int CACHE_SIZE = 6;
    private static int nextIndex;
    private static final int MIN_CHAR_INDEX = 87;
    private static final int MAX_CHAR_INDEX = 88;
    private static final FontRenderContext DEFAULT_FRC;
    public static final FontRenderContext AA_FRC;
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;
    private static final StringBuilder SKIP_CLICK_COUNT;
    public static final boolean DRAG_FIX;

    static {
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        SKIP_CLICK_COUNT = new StringBuilder("skipClickCount");
        String aa = AccessController.doPrivileged(new GetPropertyAction("swing.aatext"));
        AA_TEXT_DEFINED = aa != null;
        AA_TEXT = "true".equals(aa);
        AA_FRC = new FontRenderContext(null, true, false);
        String dragFix = AccessController.doPrivileged(new GetPropertyAction("sun.swing.enableImprovedDragGesture"));
        DRAG_FIX = dragFix != null;
    }

    NLUtils() {
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g) {
        return NLUtils.getFontMetrics(c, g, g.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        if (c != null) {
            return c.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        return fm.stringWidth(string);
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        Graphics2D g2d;
        if (text == null || text.length() <= 0) {
            return;
        }
        if (NLUtils.isPrinting(g) && (g2d = NLUtils.getGraphics2D(g)) != null) {
            TextLayout layout = new TextLayout(text, g2d.getFont(), DEFAULT_FRC);
            Color col = g2d.getColor();
            if (col instanceof PrintColorUIResource) {
                g2d.setColor(((PrintColorUIResource)col).getPrintColor());
            }
            layout.draw(g2d, x, y);
            g2d.setColor(col);
            return;
        }
        if (NLUtils.drawTextAntialiased(c) && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(text, x, y);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        } else {
            g.drawString(text, x, y);
        }
    }

    static boolean isPrinting(Graphics g) {
        return g instanceof PrinterGraphics || g instanceof PrintGraphics;
    }

    private static boolean drawTextAntialiased(JComponent c) {
        if (!AA_TEXT_DEFINED) {
            if (c != null) {
                return false;
            }
            return false;
        }
        return AA_TEXT;
    }

    public static boolean drawTextAntialiased(boolean aaText) {
        if (!AA_TEXT_DEFINED) {
            return aaText;
        }
        return AA_TEXT;
    }

    public static Graphics2D getGraphics2D(Graphics g) {
        if (g instanceof Graphics2D) {
            return (Graphics2D)g;
        }
        if (g instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)g).getGraphics();
        }
        return null;
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        NLUtils.drawString(c, g, text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + NLUtils.stringWidth(c, fm, text.substring(0, underlinedIndex));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + 1, underlineRectWidth, underlineRectHeight);
        }
    }

    public static String clipStringIfNecessary(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        if (string == null || string.equals("")) {
            return "";
        }
        int textWidth = NLUtils.stringWidth(c, fm, string);
        if (textWidth > availTextWidth) {
            return NLUtils.clipString(c, fm, string, availTextWidth);
        }
        return string;
    }

    public static String clipString(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        String clipString = "...";
        int width = NLUtils.stringWidth(c, fm, clipString);
        int nChars = 0;
        int max = string.length();
        while (nChars < max) {
            if ((width += fm.charWidth(string.charAt(nChars))) > availTextWidth) break;
            ++nChars;
        }
        string = String.valueOf(string.substring(0, nChars)) + clipString;
        return string;
    }
}

