/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import com.eva.epc.lnf.nimbuslike.NLIconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class NLSplitPaneDivider
extends BasicSplitPaneDivider {
    private int oneTouchSize = 6;
    private int oneTouchOffset = 2;

    public NLSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new DividerLayout22());
        this.setBorder(null);
    }

    @Override
    public void paint(Graphics g) {
        Color bgColor = this.splitPane.hasFocus() ? UIManager.getColor("SplitPane.shadow") : this.getBackground();
        Dimension size = this.getSize();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (bgColor != null) {
            int orient = this.splitPane.getOrientation();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        super.paint(g);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(this.oneTouchSize, this.oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        b.setIcon(this.orientation == 0 ? NLIconFactory.getInstance().getSplitPaneTouchButton_v1_Icon() : NLIconFactory.getInstance().getSplitPaneTouchButton_h1_Icon());
        return b;
    }

    protected class DividerLayout22
    implements LayoutManager {
        protected DividerLayout22() {
        }

        @Override
        public void layoutContainer(Container c) {
            if (NLSplitPaneDivider.this.leftButton != null && NLSplitPaneDivider.this.rightButton != null && c == NLSplitPaneDivider.this) {
                if (NLSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = NLSplitPaneDivider.this.getInsets();
                    if (NLSplitPaneDivider.this.orientation == 0) {
                        int extraX = insets != null ? insets.left : 0;
                        extraX += (NLSplitPaneDivider.this.getWidth() - (insets != null ? insets.right : 0)) / 2;
                        int blockSize = NLSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, NLSplitPaneDivider.this.oneTouchSize);
                        int y = (c.getSize().height - blockSize) / 2;
                        NLSplitPaneDivider.this.leftButton.setBounds(extraX + NLSplitPaneDivider.this.oneTouchOffset, y - 2, (int)NLSplitPaneDivider.this.leftButton.getPreferredSize().getWidth(), (int)NLSplitPaneDivider.this.leftButton.getPreferredSize().getHeight());
                    } else {
                        int extraY = insets != null ? insets.top : 0;
                        extraY += (NLSplitPaneDivider.this.getHeight() - (insets != null ? insets.bottom : 0)) / 2;
                        int blockSize = NLSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, NLSplitPaneDivider.this.oneTouchSize);
                        int x = (c.getSize().width - blockSize) / 2;
                        NLSplitPaneDivider.this.leftButton.setBounds(x - 2, extraY + NLSplitPaneDivider.this.oneTouchOffset, (int)NLSplitPaneDivider.this.leftButton.getPreferredSize().getWidth(), (int)NLSplitPaneDivider.this.leftButton.getPreferredSize().getHeight());
                    }
                } else {
                    NLSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    NLSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int width;
            if (c != NLSplitPaneDivider.this || NLSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension buttonMinSize = null;
            if (NLSplitPaneDivider.this.splitPane.isOneTouchExpandable() && NLSplitPaneDivider.this.leftButton != null) {
                buttonMinSize = NLSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = NLSplitPaneDivider.this.getInsets();
            int height = width = NLSplitPaneDivider.this.getDividerSize();
            if (NLSplitPaneDivider.this.orientation == 0) {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.height;
                    if (insets != null) {
                        size += insets.top + insets.bottom;
                    }
                    height = Math.max(height, size);
                }
                width = 1;
            } else {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.width;
                    if (insets != null) {
                        size += insets.left + insets.right;
                    }
                    width = Math.max(width, size);
                }
                height = 1;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public void addLayoutComponent(String string, Component c) {
        }
    }
}

