/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18nUtils {
    private static HashMap<String, ResourceBundle> resObjCache = new HashMap(1);

    public static ResourceBundle getResObj(String resFullQualifyName) {
        ResourceBundle resObj = resObjCache.get(resFullQualifyName);
        if (resObj != null) {
            return resObj;
        }
        Class<?> resClass = null;
        try {
            resClass = Class.forName(I18nUtils.getI18NResClass(resFullQualifyName));
        }
        catch (Exception e) {
            try {
                resClass = Class.forName(resFullQualifyName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resClass == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8d44\u6e90\u6587\u4ef6res=" + resFullQualifyName);
        }
        try {
            resObj = (ResourceBundle)resClass.newInstance();
            resObjCache.put(resFullQualifyName, resObj);
            return resObj;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static String getI18NResClass(String resFullQualifyName) {
        Locale defaultLocale = Locale.getDefault();
        String resClassName = resFullQualifyName;
        if (defaultLocale.toString().length() > 0) {
            resClassName = resClassName.concat("_").concat(defaultLocale.toString());
        } else if (defaultLocale.getVariant().length() > 0) {
            resClassName = resClassName.concat("___").concat(defaultLocale.getVariant());
        }
        return resClassName;
    }
}

