/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

import com.eva.epc.common.util.SimpleLogger;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtils {
    public static String byteToHexStringForMD5(byte[] MD5Bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] str = new char[32];
        int k = 0;
        int i = 0;
        while (i < 16) {
            byte byte0 = MD5Bytes[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
            ++i;
        }
        String s = new String(str);
        return s;
    }

    public static String stringNULL(String str, boolean needTrim) {
        return CommonUtils.isStringEmpty(str, needTrim) ? "" : str;
    }

    public static String stringNULL(String str, boolean needTrim, String willPreAppend) {
        return CommonUtils.isStringEmpty(str, needTrim) ? "" : String.valueOf(willPreAppend) + str;
    }

    public static String escapeXML(String beforeEscapeXML) {
        return beforeEscapeXML.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static Object[][] to2DArray(Vector<Vector> towDVector) {
        Object[][] towDArray = new Object[towDVector.size()][];
        int i = 0;
        while (i < towDVector.size()) {
            Vector row = towDVector.elementAt(i);
            towDArray[i] = row.toArray();
            ++i;
        }
        return towDArray;
    }

    public static Vector to2DVector(Object[][] src) {
        return CommonUtils.to2DVector(src, new Vector());
    }

    public static Vector to2DVector(Object[][] src, Vector dest) {
        if (src != null && src.length > 0) {
            int i = 0;
            while (i < src.length) {
                dest.addElement(CommonUtils.toVector(src[i]));
                ++i;
            }
        }
        return dest;
    }

    public static Vector toVector(Object[] src) {
        return CommonUtils.toVector(src, new Vector());
    }

    public static Vector toVector(Object[] src, Vector dest) {
        if (src != null && src.length > 0) {
            int i = 0;
            while (i < src.length) {
                dest.addElement(src[i]);
                ++i;
            }
        }
        return dest;
    }

    public static int[] getFlowingNums(int seed, int stepping, int count) {
        int[] nums = new int[count];
        int i = 0;
        while (i < count) {
            nums[i] = seed + stepping * (i + 1);
            ++i;
        }
        return nums;
    }

    public static String[] sequence(long currentValue, int count, int digit, String appendStr) throws Exception {
        if (count < 1) {
            String warn = "count\u4e0d\u80fd\u5c0f\u4e8e1\uff0ccurrentValue=" + currentValue + " =" + count + " digit=" + digit + " appendStr=" + appendStr;
            SimpleLogger.w(warn);
            throw new Exception(warn);
        }
        String[] sns = new String[count];
        int i = 0;
        while (i < count) {
            sns[i] = String.valueOf(appendStr) + CommonUtils.hiString("" + (currentValue + (long)i), digit, '0', true, false);
            ++i;
        }
        return sns;
    }

    public static final String encyptPassword(String originalPsw, String DEFAULT_PASSWORD) {
        if (originalPsw == null) {
            return null;
        }
        if (!DEFAULT_PASSWORD.equals(originalPsw)) {
            try {
                return CommonUtils.byteToHexStringForMD5(MessageDigest.getInstance("MD5").digest(originalPsw.getBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return originalPsw;
    }

    @Deprecated
    public static final byte[] encyptPasswordOld(char[] raw, String DEFAULT_PASSWORD) {
        if (raw == null) {
            return null;
        }
        byte[] byteRaw = new String(raw).getBytes();
        if (!Arrays.equals(raw, DEFAULT_PASSWORD.toCharArray())) {
            try {
                byteRaw = MessageDigest.getInstance("SHA").digest(byteRaw);
                long v = 0L;
                int len = byteRaw.length;
                int n = Math.min(len, 8);
                int i = 0;
                while (i < n) {
                    v += (long)(byteRaw[i] + n & 0xFF) << i * 8;
                    ++i;
                }
                byteRaw = Long.toString(v).getBytes();
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
        }
        return byteRaw;
    }

    public static Date getFirstDayTime(Calendar c) {
        c.add(5, -c.get(5) + 1);
        c.set(11, 0);
        c.set(12, 0);
        return c.getTime();
    }

    public static Date getFirstDayTime() {
        Calendar c = Calendar.getInstance();
        return CommonUtils.getFirstDayTime(c);
    }

    public static Date getLastDayTime(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        return c.getTime();
    }

    public static Date getLastDayTime() {
        Calendar c = Calendar.getInstance();
        return CommonUtils.getLastDayTime(c);
    }

    public static String getDateDepthed(String srcDate, int depth, int calendarField) {
        try {
            Date csrq = DateFormat.getDateInstance().parse(srcDate);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(csrq);
            gc.add(calendarField, depth);
            return new SimpleDateFormat("yyyy-MM-dd").format(gc.getTime());
        }
        catch (Exception ee) {
            return null;
        }
    }

    public static ArrayList getSplitedPartByBrackets(String str) {
        return CommonUtils.getSplitedPartByBrackets(str, '{', '}');
    }

    public static ArrayList getSplitedPartByBrackets(String str, char startBracket, char endBracket) {
        ArrayList<String> res = new ArrayList<String>();
        if (str != null) {
            int point = 0;
            int start = -1;
            while (point < str.length()) {
                char c = str.charAt(point);
                if (c == startBracket) {
                    start = point;
                } else if (c == endBracket && start != -1) {
                    res.add(str.substring(start, point + 1));
                    start = -1;
                }
                ++point;
            }
        }
        return res;
    }

    public static String firstCharUpper(String s) {
        if (s == null || (s = s.trim()).equals("")) {
            return null;
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1, s.length());
    }

    public static double getScaledDoubleValue(double d, int precision) {
        return CommonUtils.getScaledValue(d, precision).doubleValue();
    }

    public static BigDecimal getScaledValue(double d, int precision) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.divide(new BigDecimal("1"), precision < 0 ? 0 : precision, 4);
        return bd;
    }

    public static String getScaledValue(Object d, int precision, boolean trimTail) {
        String ori_str = d.toString();
        try {
            Double doubleStr = new Double(ori_str);
            return CommonUtils.getScaledValue(Double.parseDouble(ori_str), precision, trimTail);
        }
        catch (Exception ex) {
            return "0";
        }
    }

    public static String getScaledValue(double d, int precision, boolean trimTail) {
        String str = CommonUtils.getScaledValue(d, precision).toString();
        if (trimTail && precision > 0) {
            StringBuffer sb = new StringBuffer(str);
            while (sb.length() > 0) {
                char c = sb.charAt(sb.length() - 1);
                if (c == '0' || c == '.') {
                    sb.deleteCharAt(sb.length() - 1);
                    if (c != '.') continue;
                    return sb.toString();
                }
                return sb.toString();
            }
        }
        return str;
    }

    public static String[] breakStringByReturnChar(String str) {
        return CommonUtils.splitStringByChar(str, "\n");
    }

    public static String[] splitStringByChar(String str, String c) {
        ArrayList resultAl = CommonUtils.splitStringByCharC(str, c);
        String[] strs = new String[resultAl.size()];
        resultAl.toArray(strs);
        return strs;
    }

    public static ArrayList splitStringByCharC(String str, String c) {
        StringTokenizer en = new StringTokenizer(str, c);
        ArrayList<Object> vec = new ArrayList<Object>();
        while (en.hasMoreElements()) {
            vec.add(en.nextElement());
        }
        return vec;
    }

    public static String hiString(String originalStr, int theLength) {
        return CommonUtils.hiString(originalStr, theLength, '0');
    }

    public static String hiString(String originalStr, int theLength, char stuffChar) {
        return CommonUtils.hiString(originalStr, theLength, stuffChar, true, true);
    }

    public static String hiString(String originalStr, int theLength, char stuffChar, boolean stuffToLeft, boolean trucateIfLong) {
        if (originalStr.getBytes().length > theLength) {
            if (trucateIfLong) {
                return new String(originalStr.getBytes(), 0, theLength);
            }
            return originalStr;
        }
        if (originalStr.getBytes().length < theLength) {
            StringBuffer dst = new StringBuffer();
            int i = 0;
            while (i < theLength - originalStr.getBytes().length) {
                dst.append(stuffChar);
                ++i;
            }
            if (stuffToLeft) {
                dst.append(originalStr);
            } else {
                dst = new StringBuffer(originalStr).append(dst.toString());
            }
            return dst.toString();
        }
        return originalStr;
    }

    public static String truncString(String msg, int maxLen, String trailStr) {
        int max;
        int len;
        String ret = msg;
        if (msg != null && (len = msg.length()) > (max = maxLen - (trailStr != null ? trailStr.length() : 0))) {
            System.out.println("\u6587\u672c\u5185\u5bb9\u8d85\u957f\uff08\u957f\u5ea6=" + len + ",\u4f46\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6=" + max + "\uff09\uff0c\u5185\u5bb9\u5176\u4f59\u90e8\u5206\u5c06\u88ab\u622a\u65ad\uff01");
            ret = String.valueOf(CommonUtils.truncString(msg, max)) + (trailStr != null ? trailStr : "");
        }
        return ret;
    }

    public static String truncStringEx(String msg, int maxLen, String trailStr) {
        int max;
        int len;
        String ret = msg;
        if (msg != null && (len = msg.getBytes().length) > (max = maxLen - (trailStr != null ? trailStr.length() : 0))) {
            ret = String.valueOf(CommonUtils.truncStringEx(msg, max)) + (trailStr != null ? trailStr : "");
        }
        return ret;
    }

    public static String truncString(String msg, int maxLen) {
        String ret = msg;
        if (msg != null && msg.length() > maxLen) {
            ret = msg.substring(0, maxLen);
        }
        return ret;
    }

    public static String truncStringEx(String msg, int maxLen) {
        String ret = msg;
        if (msg != null && msg.length() > maxLen) {
            byte[] bs = msg.getBytes();
            byte[] tmp = new byte[maxLen];
            System.arraycopy(bs, 0, tmp, 0, maxLen);
            ret = new String(tmp);
        }
        return ret;
    }

    public static boolean isStringEmpty(String s, boolean needTrim) {
        return s == null || !(needTrim ? !s.trim().equals("") : !s.equals(""));
    }

    public static boolean isStringEmpty(String s) {
        return CommonUtils.isStringEmpty(s, false);
    }

    public static double getDoubleValue(String s) {
        return CommonUtils.getDoubleValue(s, 0.0);
    }

    public static double getDoubleValue(Object obj, double defaultVal) {
        String value = String.valueOf(obj);
        return obj == null || CommonUtils.isStringEmpty(value, true) ? defaultVal : Double.parseDouble(value);
    }

    public static int getIntValue(Object ob) {
        return CommonUtils.getIntValue(ob, 0);
    }

    public static int getIntValue(Object obj, int defaultVal) {
        String value = String.valueOf(obj);
        return obj == null || CommonUtils.isStringEmpty(value, true) ? defaultVal : Integer.parseInt(value);
    }

    public static String getJavaHomePath() {
        String javaHome = System.getProperty("java.home");
        return String.valueOf(javaHome) + "/bin";
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getRandomStr() {
        return CommonUtils.getRandomStr(20);
    }

    public static String getRandomStr(int len) {
        int rdGet2;
        int rdGet1;
        Random rd = new Random();
        String retStr = "";
        do {
            rdGet1 = Math.abs(rd.nextInt()) % 10;
            rdGet2 = Math.abs(rd.nextInt()) % 26 + 65;
        } while ((retStr = String.valueOf(retStr) + rdGet1 + (char)rdGet2).length() < len);
        return retStr;
    }

    public static String getRandomStr2(int len) {
        int rdGet2;
        int rdGet1;
        int decide;
        Random rd = new Random();
        String retStr = "";
        do {
            rdGet1 = -1;
            rdGet2 = -1;
            decide = Math.abs(rd.nextInt()) % 2;
            if (decide == 0) {
                rdGet1 = Math.abs(rd.nextInt()) % 10;
                continue;
            }
            rdGet2 = Math.abs(rd.nextInt()) % 26 + 65;
        } while ((retStr = String.valueOf(retStr) + (decide == 0 ? Integer.valueOf(rdGet1) : "" + (char)rdGet2)).length() < len);
        return retStr;
    }

    public static String getTimeWithStr() {
        return CommonUtils.getTimeWithStr(":");
    }

    public static String getTimeWithStr(String separator) {
        Calendar calendar = Calendar.getInstance();
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        int ms = calendar.get(14);
        String time = (h >= 10 ? "" + h : "0" + h) + separator + (m >= 10 ? "" + m : "0" + m) + separator + s + separator + ms;
        return time;
    }

    public static String getDateWithStr() {
        Calendar calendar = Calendar.getInstance();
        int y = calendar.get(1);
        int M = calendar.get(2) + 1;
        int d = calendar.get(5);
        String date = y + "-" + (M >= 10 ? "" + M : "0" + M) + "-" + (d >= 10 ? "" + d : "0" + d);
        return date;
    }

    public static String getConvenientFileSize(double size, int scale) {
        String ret = String.valueOf(size) + "\u5b57\u8282";
        double temp = size / 1024.0;
        if (temp >= 1.0) {
            ret = String.valueOf(CommonUtils.roundEx(temp, scale)) + "KB";
            if ((temp /= 1024.0) >= 1.0) {
                ret = String.valueOf(CommonUtils.roundEx(temp, scale)) + "MB";
                if ((temp /= 1024.0) >= 1.0) {
                    ret = String.valueOf(CommonUtils.roundEx(temp, scale)) + "GB";
                    if ((temp /= 1024.0) >= 1.0) {
                        ret = String.valueOf(new DecimalFormat("#0.00").format(CommonUtils.roundEx(temp, scale))) + "TB";
                    }
                }
            }
        }
        return ret;
    }

    public static double roundEx(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero!");
        }
        BigDecimal data = new BigDecimal(Double.toString(v));
        BigDecimal divisor = new BigDecimal("1");
        return data.divide(divisor, scale, 5).doubleValue();
    }

    private static String concatOneMACAddr(byte[] mac) {
        String macStr = "";
        if (mac == null || mac.length == 0) {
            return null;
        }
        int i = 0;
        byte[] byArray = mac;
        int n = mac.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String s = Integer.toHexString(b & 0xFF).toUpperCase();
            macStr = String.valueOf(macStr) + (s.length() == 1 ? "0" + s : s) + (i == mac.length - 1 ? "" : "-");
            ++i;
            ++n2;
        }
        return macStr;
    }

    public static String getMACAddresses() throws Exception {
        String macStr = "";
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            Method m = NetworkInterface.class.getMethod("getHardwareAddress", null);
            byte[] mac = (byte[])m.invoke((Object)ni, null);
            String oneMACStr = CommonUtils.concatOneMACAddr(mac);
            if (CommonUtils.isStringEmpty(oneMACStr, true)) continue;
            macStr = String.valueOf(macStr) + (CommonUtils.isStringEmpty(macStr, true) ? "" : ",") + oneMACStr;
        }
        return macStr;
    }

    public static boolean isNumber(char c) {
        switch (c) {
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
        }
        return false;
    }
}

