/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.calendar;

import com.eva.epc.common.calendar.ChineseCalendar;
import com.eva.epc.common.calendar.LunarDate;
import com.eva.epc.common.calendar.MyDate;
import com.eva.epc.common.calendar.Week;

public class SolarDate
extends MyDate {
    private static int checkMonth(int iMonth) {
        if (iMonth > 12) {
            System.out.println("Month out of range, I think you want 12 ");
            return 12;
        }
        if (iMonth < 1) {
            System.out.println("Month out of range, I think you want 1 ");
            return 1;
        }
        return iMonth;
    }

    private static int checkDay(int iYear, int iMonth, int iDay) {
        int iMonthDays = ChineseCalendar.iGetSYearMonthDays(iYear, iMonth);
        if (iDay > iMonthDays) {
            System.out.println("Day out of range, I think you want " + iMonthDays + " ");
            return iMonthDays;
        }
        if (iDay < 1) {
            System.out.println("Day out of range, I think you want 1 ");
            return 1;
        }
        return iDay;
    }

    public SolarDate(int iYear, int iMonth, int iDay) {
        super(iYear);
        this.iMonth = SolarDate.checkMonth(iMonth);
        this.iDay = SolarDate.checkDay(this.iYear, this.iMonth, iDay);
    }

    public SolarDate(int iYear, int iMonth) {
        super(iYear);
        this.iMonth = SolarDate.checkMonth(iMonth);
    }

    public SolarDate(int iYear) {
        super(iYear);
    }

    public SolarDate() {
    }

    public String toString() {
        return this.iYear + (this.iMonth > 9 ? "-" + this.iMonth : "-0" + this.iMonth) + (this.iDay > 9 ? "-" + this.iDay : "-0" + this.iDay);
    }

    public Week toWeek() {
        int iOffsetDays = 0;
        int i = 1901;
        while (i < this.iYear) {
            iOffsetDays = ChineseCalendar.bIsSolarLeapYear(i) ? (iOffsetDays += 366) : (iOffsetDays += 365);
            ++i;
        }
        return new Week(((iOffsetDays += ChineseCalendar.iGetSNewYearOffsetDays(this.iYear, this.iMonth, this.iDay)) + 2) % 7);
    }

    public LunarDate toLunarDate() {
        int iDate = Integer.parseInt(ChineseCalendar.sCalendarSolarToLundar(this.iYear, this.iMonth, this.iDay));
        int iYear = iDate / 10000;
        int iMonth = iDate % 10000 / 100;
        int iDay = iDate % 100;
        LunarDate ld = new LunarDate(iYear, iMonth, iDay);
        return ld;
    }
}

