/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class WindowUtils {
    private static final Logger LOG = Logger.getLogger(WindowUtils.class.getName());

    private WindowUtils() {
    }

    public static Point getPointForCentering(Window window) {
        Rectangle usableBounds = WindowUtils.getUsableDeviceBounds(window);
        int screenWidth = usableBounds.width;
        int screenHeight = usableBounds.height;
        int width = window.getWidth();
        int height = window.getHeight();
        return new Point((screenWidth - width) / 2 + usableBounds.x, (screenHeight - height) / 2 + usableBounds.y);
    }

    public static Rectangle getUsableDeviceBounds(Window window) {
        Window owner = window.getOwner();
        GraphicsConfiguration gc = null;
        gc = owner == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : owner.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle bounds = gc.getBounds();
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public static Point getPointForCentering(JInternalFrame window) {
        try {
            GraphicsDevice[] devices;
            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
            GraphicsDevice[] graphicsDeviceArray = devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice device = graphicsDeviceArray[n2];
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                if (mousePoint.x >= bounds.x && mousePoint.y >= bounds.y && mousePoint.x <= bounds.x + bounds.width && mousePoint.y <= bounds.y + bounds.height) {
                    int screenWidth = bounds.width;
                    int screenHeight = bounds.height;
                    int width = window.getWidth();
                    int height = window.getHeight();
                    return new Point((screenWidth - width) / 2 + bounds.x, (screenHeight - height) / 2 + bounds.y);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, String.valueOf(e.getLocalizedMessage()) + " - this can occur do to a Security exception in sandboxed apps");
        }
        return new Point(0, 0);
    }

    public static Point getPointForStaggering(Window originWindow) {
        Point origin = originWindow.getLocation();
        Insets insets = originWindow.getInsets();
        origin.x += insets.top;
        origin.y += insets.top;
        return origin;
    }

    public static Window findWindow(Component c) {
        if (c == null) {
            return JOptionPane.getRootFrame();
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return WindowUtils.findWindow(c.getParent());
    }

    public static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            compList.add(comp);
            if (comp instanceof Container) {
                compList.addAll(WindowUtils.getAllComponents((Container)comp));
            }
            ++n2;
        }
        return compList;
    }

    public static void setMinimumSizeManager(Window window, int minWidth, int minHeight) {
        ComponentListener[] listeners = window.getComponentListeners();
        ComponentListener listener = null;
        ComponentListener[] componentListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentListener l = componentListenerArray[n2];
            if (l instanceof MinSizeComponentListener) {
                listener = l;
                break;
            }
            ++n2;
        }
        if (listener == null) {
            window.addComponentListener(new MinSizeComponentListener(window, minWidth, minHeight));
        } else {
            ((MinSizeComponentListener)listener).resetSizes(minWidth, minHeight);
        }
    }

    public static class MinSizeComponentListener
    extends ComponentAdapter {
        private Window window;
        private int minHeight;
        private int minWidth;

        MinSizeComponentListener(Window frame, int minWidth, int minHeight) {
            this.window = frame;
            this.resetSizes(minWidth, minHeight);
        }

        public void resetSizes(int minWidth, int minHeight) {
            this.minWidth = minWidth;
            this.minHeight = minHeight;
            this.adjustIfNeeded(this.window);
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            this.adjustIfNeeded((Window)evt.getComponent());
        }

        private void adjustIfNeeded(final Window window) {
            boolean doSize = false;
            int newWidth = window.getWidth();
            int newHeight = window.getHeight();
            if (newWidth < this.minWidth) {
                newWidth = this.minWidth;
                doSize = true;
            }
            if (newHeight < this.minHeight) {
                newHeight = this.minHeight;
                doSize = true;
            }
            if (doSize) {
                final int w = newWidth;
                final int h = newHeight;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        window.setSize(w, h);
                    }
                });
            }
        }
    }
}

