/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class WindowEfect
implements ActionListener {
    private static final int ANIMATION_FRAMES = 15;
    private static boolean isShow = true;
    private Window window;
    private Dimension full_size;
    private Timer timer;
    private int frameIndex;
    private boolean needClose = false;

    public static void show(Window w) {
        isShow = true;
        if (w.isVisible()) {
            return;
        }
        new WindowEfect(w).invoke();
    }

    public static void unshow(Window w, boolean needClose) {
        isShow = false;
        if (!w.isVisible()) {
            return;
        }
        new WindowEfect(w).invoke(needClose);
    }

    private WindowEfect(Window w) {
        this.window = w;
        this.full_size = this.window.getSize();
        this.timer = new Timer(5, this);
        if (isShow) {
            this.frameIndex = 0;
            this.window.setSize(0, 0);
        } else {
            this.frameIndex = 15;
        }
    }

    private void invoke(boolean needClose) {
        this.needClose = needClose;
        this.timer.start();
    }

    private void invoke() {
        if (isShow) {
            if (!this.window.isVisible()) {
                this.timer.start();
                this.window.setVisible(true);
            }
        } else {
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int w = this.full_size.width * this.frameIndex / 15;
        int h = this.full_size.height * this.frameIndex / 15;
        this.window.setSize(w, h);
        if (isShow) {
            if (this.frameIndex == 15) {
                this.doExit();
                this.window.setVisible(false);
                this.window.setVisible(true);
            } else {
                ++this.frameIndex;
            }
        } else if (this.frameIndex == 0) {
            this.doExit();
            this.window.setVisible(false);
            this.window.setSize(this.full_size);
            if (this.needClose) {
                this.window.dispose();
            }
        } else {
            --this.frameIndex;
        }
    }

    private void doExit() {
        this.timer.stop();
        this.timer = null;
    }
}

