/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.text;

import com.eva.epc.common.util.CommonUtils;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DoubleDocument
extends PlainDocument {
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.MAX_VALUE;
    private int scale = Integer.MAX_VALUE;

    public DoubleDocument(double minValue, double maxValue, int scale) {
        this.setMin(minValue);
        this.setScale(scale);
        this.setMax(maxValue);
    }

    public DoubleDocument(int scale) {
        this(Double.NEGATIVE_INFINITY, Double.MAX_VALUE, scale);
    }

    public DoubleDocument() {
    }

    public void setScale(int newScale) {
        if (newScale < 0) {
            throw new IllegalArgumentException();
        }
        this.scale = newScale;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String originalInput;
        if (str == null) {
            return;
        }
        if ((str = str.trim()).length() < 1) {
            return;
        }
        int currLen = this.getLength();
        if (currLen == 0) {
            originalInput = str;
        } else {
            StringBuffer currentBuffer = new StringBuffer(super.getText(0, currLen));
            currentBuffer.insert(offs, str);
            originalInput = currentBuffer.toString();
        }
        try {
            str = str.toLowerCase().replace('f', ' ').trim().replace('d', ' ').trim();
            this.processOriginalInput(originalInput);
            int dot = originalInput.indexOf(".");
            if (dot != -1 && (originalInput.substring(dot + 1).length() > this.scale || this.scale == 0)) {
                if (currLen == 0) {
                    str = CommonUtils.getScaledValue((double)Double.parseDouble(str), (int)this.scale, (boolean)true);
                } else {
                    throw new Exception("");
                }
            }
            super.insertString(offs, str, a);
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void processOriginalInput(String originalInput) throws NumberFormatException {
        boolean litterZero;
        int length = originalInput.length();
        boolean bl = litterZero = this.min < 0.0;
        if (length == 1 && (originalInput.startsWith("-") && litterZero || this.scale > 0 && originalInput.startsWith("."))) {
            return;
        }
        double value = Double.parseDouble(originalInput);
        if (value > this.max || litterZero && value < this.min || !litterZero && value < 0.0) {
            throw new NumberFormatException();
        }
    }

    public void setMax(double maxValue) {
        this.max = maxValue;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double minValue) {
        this.min = minValue;
    }

    public double getMin() {
        return this.min;
    }
}

