/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.table;

import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.widget.ELineNumTable;
import com.eva.epc.widget.ETableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.table.TableCellRenderer;

public class ColorableTable
extends ELineNumTable {
    private HashMap<Object, Color> valueAndColors = null;
    private int beColoredColumn = -1;
    private ValueType currentValueType = ValueType.String;

    public ColorableTable(ETableModel destModel) {
        this(destModel, -1);
    }

    public ColorableTable(ETableModel destModel, int beColoredColumn) {
        this(destModel, beColoredColumn, ValueType.String);
    }

    public ColorableTable(ETableModel destModel, int beColoredColumn, ValueType valueType) {
        super(destModel);
        this.beColoredColumn = beColoredColumn;
        this.currentValueType = valueType;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        for (Object value : this.valueAndColors.keySet()) {
            String cellValue;
            Color color = this.valueAndColors.get(value);
            if (this.currentValueType == ValueType.String) {
                if (!this.getValueAt(row, this.beColoredColumn).equals(value)) continue;
                ((Component)((Object)renderer)).setBackground(color);
                continue;
            }
            if (this.currentValueType != ValueType.Integer || (cellValue = (String)this.getValueAt(row, this.beColoredColumn)) == null || (int)CommonUtils.getDoubleValue((String)cellValue) != (Integer)value) continue;
            ((Component)((Object)renderer)).setBackground(color);
        }
        return renderer;
    }

    public int getBeColoredColumn() {
        return this.beColoredColumn;
    }

    public ColorableTable setBeColoredColumn(int beColoredColumn) {
        this.beColoredColumn = beColoredColumn;
        return this;
    }

    public ColorableTable addValueAndColor(Object value, Color showColor) {
        if (this.valueAndColors == null) {
            this.valueAndColors = new HashMap();
        }
        this.valueAndColors.put(value, showColor);
        return this;
    }

    public ValueType getCurrentValueType() {
        return this.currentValueType;
    }

    public ColorableTable setCurrentValueType(ValueType currentValueType) {
        this.currentValueType = currentValueType;
        return this;
    }

    public static enum ValueType {
        String,
        Integer;

    }
}

