/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.border;

import com.eva.epc.widget.util.GraphicHandler;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ETitledMatteBorder
extends EmptyBorder {
    protected Color color = UIManager.getColor("Panel.background");
    protected Icon tileBgIcon;
    private String title = null;
    private Color borderColor = null;
    protected ImageIcon leftTopIcon = null;
    private Font titleFont = new Font("\u5b8b\u4f53", 1, 16);
    private boolean aa = true;
    private boolean drawStringAfterLeftTopIcon = false;
    private Color titleForegeColor = new Color(38, 38, 38);

    public ETitledMatteBorder(int height) {
        super(height, 0, 0, 0);
    }

    public ETitledMatteBorder(int height, Color matteColor) {
        super(height, 0, 0, 0);
        this.color = matteColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(c);
        Color oldColor = g.getColor();
        g.translate(x, y);
        if (this.tileBgIcon != null) {
            Color color = this.color = this.tileBgIcon.getIconWidth() == -1 ? Color.gray : null;
        }
        if (this.color != null) {
            g.setColor(this.color);
            Graphics2D g2 = (Graphics2D)g;
            Paint oldp = g2.getPaint();
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getColor(10, 10, 10), 0.0f, insets.top / 2, this.color);
            g2.setPaint(gp);
            g2.fillRect(0, 0, width - insets.right, insets.top / 2);
            g2.setPaint(oldp);
            g2.setColor(this.getColor(-8, -8, -8));
            g2.fillRect(0, insets.top / 2, width - insets.right, insets.top / 2);
            if (this.borderColor != null) {
                g2.setColor(this.borderColor);
                g2.drawLine(0, insets.top, width - insets.right, insets.top);
            }
        } else if (this.tileBgIcon != null) {
            int xpos;
            int tileW = this.tileBgIcon.getIconWidth();
            int tileH = this.tileBgIcon.getIconHeight();
            Graphics cg = g.create();
            cg.setClip(0, 0, width, insets.top);
            int ypos = 0;
            while (insets.top - ypos > 0) {
                xpos = 0;
                while (width - xpos > 0) {
                    this.tileBgIcon.paintIcon(c, cg, xpos, ypos);
                    xpos += tileW;
                }
                ypos += tileH;
            }
            cg.dispose();
            cg = g.create();
            cg.setClip(0, insets.top, insets.left, height - insets.top);
            int starty = insets.top - insets.top % tileH;
            int startx = 0;
            ypos = starty;
            while (height - ypos > 0) {
                xpos = startx;
                while (insets.left - xpos > 0) {
                    this.tileBgIcon.paintIcon(c, cg, xpos, ypos);
                    xpos += tileW;
                }
                ypos += tileH;
            }
            cg.dispose();
            cg = g.create();
            cg.setClip(insets.left, height - insets.bottom, width - insets.left, insets.bottom);
            starty = height - insets.bottom - (height - insets.bottom) % tileH;
            startx = insets.left - insets.left % tileW;
            ypos = starty;
            while (height - ypos > 0) {
                xpos = startx;
                while (width - xpos > 0) {
                    this.tileBgIcon.paintIcon(c, cg, xpos, ypos);
                    xpos += tileW;
                }
                ypos += tileH;
            }
            cg.dispose();
            cg = g.create();
            cg.setClip(width - insets.right, insets.top, insets.right, height - insets.top - insets.bottom);
            starty = insets.top - insets.top % tileH;
            startx = width - insets.right - (width - insets.right) % tileW;
            ypos = starty;
            while (height - ypos > 0) {
                xpos = startx;
                while (width - xpos > 0) {
                    this.tileBgIcon.paintIcon(c, cg, xpos, ypos);
                    xpos += tileW;
                }
                ypos += tileH;
            }
            cg.dispose();
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
        if (this.isLeftTopIconPaint()) {
            g.drawImage(this.leftTopIcon.getImage(), x, y, this.leftTopIcon.getIconWidth(), this.leftTopIcon.getIconHeight(), null);
        }
        if (this.isTitledPaint()) {
            if (this.aa) {
                SwingUtils.setAntiAliasing((Graphics2D)g, true);
            }
            Font oldf = g.getFont();
            int titleXDelta = this.isLeftTopIconPaint() && this.drawStringAfterLeftTopIcon ? this.leftTopIcon.getIconWidth() : 10;
            int titleYDelta = SwingUtils.getStrCenterDrawY(this.getHeight(), g.getFontMetrics());
            g.setFont(this.titleFont);
            g.setColor(new Color(250, 250, 250));
            ((Graphics2D)g).drawString(this.title, x + titleXDelta, y + titleYDelta);
            g.setColor(this.titleForegeColor);
            ((Graphics2D)g).drawString(this.title, x + titleXDelta, y + titleYDelta);
            g.setFont(oldf);
            if (this.aa) {
                SwingUtils.setAntiAliasing((Graphics2D)g, false);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets();
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.computeInsets(insets);
    }

    @Override
    public Insets getBorderInsets() {
        return this.computeInsets(new Insets(0, 0, 0, 0));
    }

    private Insets computeInsets(Insets insets) {
        if (this.tileBgIcon != null && this.top == -1 && this.bottom == -1 && this.left == -1 && this.right == -1) {
            int h;
            int w = this.tileBgIcon.getIconWidth();
            insets.top = h = this.tileBgIcon.getIconHeight();
            insets.right = w;
            insets.bottom = h;
            insets.left = w;
        } else {
            insets.left = this.left;
            insets.top = this.top;
            insets.right = this.right;
            insets.bottom = this.bottom;
        }
        return insets;
    }

    public Color getMatteColor() {
        return this.color;
    }

    public Color getColor() {
        return this.color;
    }

    public ETitledMatteBorder setColor(Color color) {
        this.color = color;
        return this;
    }

    public Icon getTileBgIcon() {
        return this.tileBgIcon;
    }

    public ETitledMatteBorder setTileBgIcon(Icon tileBgIcon) {
        this.tileBgIcon = tileBgIcon;
        return this;
    }

    public Icon getTileIcon() {
        return this.tileBgIcon;
    }

    @Override
    public boolean isBorderOpaque() {
        return this.color != null;
    }

    protected Color getColor(int r, int g, int b) {
        return GraphicHandler.getColor(this.color, r, g, b);
    }

    public boolean isTitledPaint() {
        return this.title != null;
    }

    public String getTitle() {
        return this.title;
    }

    public ETitledMatteBorder setTitle(String title) {
        this.title = title;
        return this;
    }

    public boolean isLeftTopIconPaint() {
        return this.leftTopIcon != null;
    }

    public ImageIcon getLeftTopIcon() {
        return this.leftTopIcon;
    }

    public ETitledMatteBorder setLeftTopIcon(ImageIcon leftTopIcon) {
        this.leftTopIcon = leftTopIcon;
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public ETitledMatteBorder setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public ETitledMatteBorder setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        return this;
    }

    public boolean isAa() {
        return this.aa;
    }

    public ETitledMatteBorder setAa(boolean aa) {
        this.aa = aa;
        return this;
    }

    public ETitledMatteBorder setHeight(int height) {
        this.top = height;
        return this;
    }

    public int getHeight() {
        return this.top;
    }

    public boolean isDrawStringAfterLeftTopIcon() {
        return this.drawStringAfterLeftTopIcon;
    }

    public ETitledMatteBorder setDrawStringAfterLeftTopIcon(boolean drawStringAfterLeftTopIcon) {
        this.drawStringAfterLeftTopIcon = drawStringAfterLeftTopIcon;
        return this;
    }

    public Color getTitleForegeColor() {
        return this.titleForegeColor;
    }

    public ETitledMatteBorder setTitleForegeColor(Color titleForegeColor) {
        this.titleForegeColor = titleForegeColor;
        return this;
    }
}

