/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

public class EShadowTitledBorder
extends AbstractBorder {
    protected Color backColor;
    protected int thickness;
    protected int thick;
    protected int px;
    protected int py;
    float fgap;
    protected int xran;
    protected int yran;
    private final int TITLE_GAP = 20;
    private String title = null;
    private ImageIcon titleIcon = null;
    private Color titleColor = new Color(128, 0, 0);
    final int TITLE_ICON_DELTA_X = 7;
    final int TITLE_ICON_DELTA_Y = 5;
    private boolean drawGradienBorder = true;
    private boolean drawTopGradienLine = true;

    public EShadowTitledBorder() {
        this(new Color(128, 128, 128));
    }

    public EShadowTitledBorder(Color color) {
        this(color, 3, -45, 0.5f, 1.0f);
    }

    public EShadowTitledBorder(Color color, int thickness) {
        this(color, thickness, -45, 0.5f, 1.0f);
    }

    public EShadowTitledBorder(Color color, int thickness, int angle, float pos, float fgap) {
        this.backColor = color == null ? new Color(128, 128, 128) : color;
        this.thickness = thickness < 4 ? 4 : thickness;
        this.fgap = fgap;
        this.xran = thickness * 2;
        this.yran = thickness * 2;
        if (pos <= 0.0f) {
            this.px = 0;
            this.py = 0;
        } else {
            float thickinpos = (float)thickness * (pos > 1.0f ? 1.0f : (pos < 0.0f ? 0.0f : pos));
            this.px = -1 * (int)((double)thickinpos * Math.cos(Math.toRadians(angle)));
            this.py = (int)((double)thickinpos * Math.sin(Math.toRadians(angle)));
        }
        this.thick = (int)(1.2 * (double)thickness + (double)(Math.abs(this.px) > Math.abs(this.py) ? Math.abs(this.px) : Math.abs(this.py)));
    }

    protected Color getColor(Color apc, Color BackColor, int thick, int i) {
        return new Color(this.getColorint(apc.getRed(), BackColor.getRed(), thick, i), this.getColorint(apc.getGreen(), BackColor.getGreen(), thick, i), this.getColorint(apc.getBlue(), BackColor.getBlue(), thick, i), this.getColorint(apc.getAlpha(), BackColor.getAlpha(), thick, i));
    }

    protected int getColorint(int a, int b, int thick, int i) {
        int cc = (int)(a < b ? (double)a + (double)this.fgap * (1.0 * (double)i / (double)thick) * (double)(b - a) : (double)a - (double)this.fgap * (1.0 * (double)i / (double)thick) * (double)(a - b));
        return cc;
    }

    @Override
    public void paintBorder(Component c, Graphics gd, int x, int y, int width, int height) {
        Color oldColor = gd.getColor();
        Graphics2D g2 = (Graphics2D)gd;
        Paint oldPaint = g2.getPaint();
        if (this.drawGradienBorder) {
            Color apc = new Color(this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), 0);
            Area a = new Area(new Rectangle(x, y, width, height));
            Area b = new Area(new Rectangle(x + this.thickness + this.px, y + this.thickness + this.py, width - this.thickness - this.thickness, height - this.thickness - this.thickness));
            a.subtract(b);
            g2.setClip(a);
            if (c instanceof JComponent && ((JComponent)c).isOpaque()) {
                Color pc = null;
                try {
                    pc = c.getParent().getBackground();
                    apc = new Color(pc.getRed(), pc.getGreen(), pc.getBlue(), 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                g2.setColor(pc);
                g2.fillRect(x, y, width, height);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int i = 0;
            while (i < this.thick) {
                g2.setColor(this.getColor(apc, this.backColor, this.thick, i));
                g2.fillRoundRect(x + i, y + i, width - 2 * i, height - 2 * i, this.xran, this.yran);
                ++i;
            }
            g2.setColor(this.backColor);
            g2.fillRoundRect(x + this.thick, y + this.thick, width - 2 * this.thick, height - 2 * this.thick, this.xran, this.yran);
            g2.setClip(null);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.titleIcon != null) {
            g2.drawImage(this.titleIcon.getImage(), 7, y + 5, this.titleIcon.getIconWidth(), this.titleIcon.getIconHeight(), null);
        }
        if (!this.titleIsEmpty()) {
            g2.setColor(new Color(255, 255, 255));
            g2.drawString(this.title, x + (this.titleIcon == null ? 0 : 20) + 5 + 1, y + 20);
            g2.setColor(this.titleColor);
            g2.drawString(this.title, x + (this.titleIcon == null ? 0 : 20) + 5, y + 20 - 1);
        }
        if (this.drawTopGradienLine && this.needDrawTitle()) {
            int titleWidth = g2.getFontMetrics().stringWidth(this.title);
            int startX = titleWidth + 30;
            g2.setColor(Color.gray);
            g2.drawLine(x + startX, y + 15, x + startX + width * 2 / 3 - startX, y + 15);
            g2.setPaint(new GradientPaint(x + width * 2 / 3, y + 15, Color.gray, x + titleWidth + width - startX, y + 15, new Color(255, 255, 255, 0)));
            g2.drawLine(x + width * 2 / 3, y + 15, x + width, y + 15);
            g2.setColor(Color.white);
            g2.drawLine(x + startX + 5, y + 16, x + width * 2 / 3, y + 16);
            g2.setPaint(new GradientPaint(x + width * 2 / 3, y + 16, Color.white, x + width, y + 16, new Color(255, 255, 255, 0)));
            g2.drawLine(x + width * 2 / 3, y + 16, x + width, y + 16);
        }
        g2.setPaint(oldPaint);
        gd.setColor(oldColor);
    }

    public boolean titleIsEmpty() {
        return this.title == null || this.title.trim().equals("");
    }

    public boolean needDrawTitle() {
        return !this.titleIsEmpty();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness + this.py + (this.needDrawTitle() ? 20 : 0), this.thickness + this.px, this.thickness - this.py, this.thickness - this.px);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.thickness + this.py;
        insets.left = this.thickness + this.px;
        insets.bottom = this.thickness - this.py;
        insets.right = this.thickness - this.px;
        return insets;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public static void createRollOverBorder(JComponent c) {
        EShadowTitledBorder.createRollOverBorder(c, new EShadowTitledBorder(new Color(0, 0, 0), 6, -45, 0.5f, 0.96f), new EShadowTitledBorder(new Color(0, 0, 0), 6, -45, 0.4f, 0.8f), new EShadowTitledBorder(new Color(0, 0, 0), 6, -45, 0.4f, 0.8f));
    }

    public static void createRollOverBorder(JComponent c, Color color, int w) {
        EShadowTitledBorder.createRollOverBorder(c, new EShadowTitledBorder(color, w, -45, 0.5f, 0.96f), new EShadowTitledBorder(color, w, -45, 0.4f, 0.8f), new EShadowTitledBorder(color, w, -45, 0.4f, 0.8f));
    }

    public static void createRollOverBorder(final JComponent c, final EShadowTitledBorder ibd, final EShadowTitledBorder pbd, final EShadowTitledBorder obd) {
        c.setBorder(obd);
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (c.isEnabled()) {
                    c.setBorder(ibd);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (c.isEnabled()) {
                    c.setBorder(obd);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (c.isEnabled()) {
                    c.setBorder(pbd);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (c.isEnabled()) {
                    c.setBorder(ibd);
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public EShadowTitledBorder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ImageIcon getTitleIcon() {
        return this.titleIcon;
    }

    public EShadowTitledBorder setTitleIcon(ImageIcon titleIcon) {
        this.titleIcon = titleIcon;
        return this;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public EShadowTitledBorder setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public int getTITLE_GAP() {
        return 20;
    }

    public boolean isDrawGradienBorder() {
        return this.drawGradienBorder;
    }

    public EShadowTitledBorder setDrawGradienBorder(boolean drawGradienBorder) {
        this.drawGradienBorder = drawGradienBorder;
        return this;
    }

    public EShadowTitledBorder setBackColor(Color backColor) {
        this.backColor = backColor;
        return this;
    }

    public boolean isDrawTopGradienLine() {
        return this.drawTopGradienLine;
    }

    public EShadowTitledBorder setDrawTopGradienLine(boolean drawTopGradienLine) {
        this.drawTopGradienLine = drawTopGradienLine;
        return this;
    }
}

