/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.widget.EAction;
import com.eva.epc.widget.EOptionPane;
import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class ETextFieldRoot
extends JTextField {
    private PropertyChangeListener extraPropertyChangeListener;
    private JComponent[] extraComs = null;
    private static final String COMPONENT_NAME_TOOL$TIP$BUTTON = "TollTipButton";

    public ETextFieldRoot() {
        this(null, null, 0);
    }

    public ETextFieldRoot(String text) {
        this(null, text, 0);
    }

    public ETextFieldRoot(int columns) {
        this(null, null, columns);
    }

    public ETextFieldRoot(String text, int columns) {
        this(null, text, columns);
    }

    public ETextFieldRoot(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.installExtraComs();
    }

    protected void installExtraComs() {
        this.extraComs = this.getExtraComponents();
        this.setLayout(this.createLayoutForExtra());
        if (this.extraComs != null && this.extraComs.length > 0) {
            JComponent[] jComponentArray = this.extraComs;
            int n = this.extraComs.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent cc = jComponentArray[n2];
                this.add((Component)cc, "");
                cc.setFocusable(false);
                ++n2;
            }
        }
        this.updateEnabledStateForExtra();
        this.extraPropertyChangeListener = this.createPropertyChangeListenerForExtra();
        this.addPropertyChangeListener(this.extraPropertyChangeListener);
    }

    public Component getComponentByName(String name) {
        if (name != null) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c.getName() != null && c.getName().equals(name)) {
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean hasToolTipText() {
        return !CommonUtils.isStringEmpty((String)this.getToolTipText(), (boolean)true);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.getComponentByName(COMPONENT_NAME_TOOL$TIP$BUTTON).setVisible(this.hasToolTipText());
    }

    protected JComponent[] getExtraComponents() {
        return new JComponent[]{this.createExtraToolTipButton()};
    }

    protected AbstractButton createExtraToolTipButton() {
        AbstractButton c = SwingUtils.createIconButton(this.createExtraToolTipAction());
        c.setName(COMPONENT_NAME_TOOL$TIP$BUTTON);
        return c;
    }

    protected Action createExtraToolTipAction() {
        return new EAction("", IconFactory.getInstance().getQuestion_GRAYIcon16_16()){

            @Override
            public void actionPerformed(ActionEvent e) {
                EOptionPane.showInfoDialog(ETextFieldRoot.this, "\u8bf4\u660e:" + ETextFieldRoot.this.getToolTipText());
            }
        }.setTooltip("\u70b9\u51fb\u67e5\u770b\u8bf4\u660e.");
    }

    private void updateEnabledStateForExtra() {
        this.updateEnabledStateForExtra(this, this.isEnabled() && this.isEditable());
    }

    private void updateEnabledStateForExtra(Container c, boolean enabled) {
        int counter = c.getComponentCount() - 1;
        while (counter >= 0) {
            Component child = c.getComponent(counter);
            child.setEnabled(enabled);
            if (child instanceof Container) {
                this.updateEnabledStateForExtra((Container)child, enabled);
            }
            --counter;
        }
    }

    protected PropertyChangeListener createPropertyChangeListenerForExtra() {
        return new PropertyChangeListenerImplForExtra();
    }

    protected LayoutManager createLayoutForExtra() {
        return new LayoutImplForExtra();
    }

    private class LayoutImplForExtra
    implements LayoutManager {
        private ArrayList<Component> extraComs = new ArrayList();

        private LayoutImplForExtra() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            this.extraComs.add(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (this.extraComs.contains(c)) {
                this.extraComs.remove(c);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            if (this.extraComs != null) {
                int rightX = width - insets.right;
                int i = this.extraComs.size() - 1;
                while (i >= 0) {
                    Component c = this.extraComs.get(i);
                    String cName = c.getName();
                    if (cName == null || !cName.equals(ETextFieldRoot.COMPONENT_NAME_TOOL$TIP$BUTTON) || ETextFieldRoot.this.hasToolTipText()) {
                        Dimension d = c.getPreferredSize();
                        rightX = rightX - (int)d.getWidth() + 5;
                        int middleY = insets.top + (height - insets.top - insets.bottom - (int)d.getHeight()) / 2;
                        this.setBounds(c, rightX, middleY, (int)d.getWidth(), (int)d.getHeight());
                    }
                    --i;
                }
            }
        }
    }

    private class PropertyChangeListenerImplForExtra
    implements PropertyChangeListener {
        private PropertyChangeListenerImplForExtra() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("enabled".equals(propertyName)) {
                ETextFieldRoot.this.updateEnabledStateForExtra();
            } else if ("editable".equals(propertyName)) {
                ETextFieldRoot.this.updateEnabledStateForExtra();
            }
        }
    }
}

