/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.lnf.nimbuslike.NLTMSchema;
import com.eva.epc.lnf.nimbuslike.NLTableHeaderUI;
import com.eva.epc.lnf.nimbuslike.NLXPStyle;
import com.eva.epc.widget.ETable;
import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.swing.UIAction;

public class ELineNumTable
extends ETable {
    protected JTable theRowHeaderImpl;

    public ELineNumTable() {
        super(null, null, null);
    }

    public ELineNumTable(TableModel tm, TableColumnModel cm, ListSelectionModel sm) {
        super(tm, cm, sm);
    }

    public ELineNumTable(TableModel tm, TableColumnModel cm) {
        super(tm, cm, null);
    }

    public ELineNumTable(TableModel tm) {
        super(tm, null, null);
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && p.getParent() instanceof JScrollPane) {
            this.enableLineNum(true);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e != null && e.getType() != 0) {
            this.aotuAdaptingLingNumWidth();
        }
    }

    private void aotuAdaptingLingNumWidth() {
        if (this.theRowHeaderImpl != null) {
            int width = (Integer.toString(this.getRowCount()).length() + 4) * this.getFontMetrics(this.getTableHeader().getFont()).charWidth('0');
            TableColumnModel tcm = this.theRowHeaderImpl.getColumnModel();
            TableColumn col = tcm.getColumn(0);
            if (col.getWidth() != width) {
                col.setWidth(width);
                col.setPreferredWidth(width);
                this.theRowHeaderImpl.setPreferredScrollableViewportSize(new Dimension(col.getWidth() + tcm.getColumnMargin() / 2, 0));
            }
        }
    }

    public void enableLineNum(boolean enable) {
        JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (scrollPane == null) {
            throw new IllegalStateException("\u672c\u8868\u683c\u4e0d\u662f\u653e\u7f6e\u4e8eJScrollPane\u4e2d\uff0c\u65e0\u6cd5\u5b9e\u73b0\u884c\u53f7\u7684\u663e\u793a\u8bbe\u7f6e.");
        }
        if (enable) {
            if (this.theRowHeaderImpl == null) {
                this.theRowHeaderImpl = new RowNumHeaderView(this);
            }
            if (this.getColumnCount() > 0) {
                this.aotuAdaptingLingNumWidth();
                scrollPane.setRowHeaderView(this.theRowHeaderImpl);
                scrollPane.setCorner("UPPER_LEFT_CORNER", this.theRowHeaderImpl.getTableHeader());
            }
        } else if (scrollPane.getRowHeader() != null) {
            scrollPane.setRowHeaderView(null);
            this.theRowHeaderImpl = null;
        }
    }

    private static class NLTableHeaderUIXX
    extends BasicTableHeaderUI {
        private TableCellRenderer originalHeaderRenderer;
        private int rolloverColumn = -1;

        private NLTableHeaderUIXX() {
        }

        public static ComponentUI createUI(JComponent h) {
            return new NLTableHeaderUIXX();
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            if (NLXPStyle.getXP() != null) {
                this.originalHeaderRenderer = this.header.getDefaultRenderer();
                if (this.originalHeaderRenderer instanceof UIResource) {
                    this.header.setDefaultRenderer(new XPDefaultRenderer());
                }
            }
        }

        private void updateRolloverColumn(MouseEvent e) {
            int col;
            if (this.header.getDraggedColumn() == null && this.header.contains(e.getPoint()) && (col = this.header.columnAtPoint(e.getPoint())) != this.rolloverColumn) {
                this.rolloverColumn = col;
                this.header.repaint();
            }
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            if (NLXPStyle.getXP() != null) {
                return new BasicTableHeaderUI.MouseInputHandler(this){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        super.mouseMoved(e);
                        NLTableHeaderUIXX.this.updateRolloverColumn(e);
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        super.mouseEntered(e);
                        NLTableHeaderUIXX.this.updateRolloverColumn(e);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        super.mouseExited(e);
                        NLTableHeaderUIXX.this.rolloverColumn = -1;
                        NLTableHeaderUIXX.this.header.repaint();
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        super.mousePressed(e);
                        if (NLTableHeaderUIXX.this.header.getReorderingAllowed()) {
                            NLTableHeaderUIXX.this.rolloverColumn = -1;
                            NLTableHeaderUIXX.this.header.repaint();
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        super.mouseDragged(e);
                        NLTableHeaderUIXX.this.updateRolloverColumn(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        super.mouseReleased(e);
                        NLTableHeaderUIXX.this.updateRolloverColumn(e);
                    }
                };
            }
            return super.createMouseInputListener();
        }

        @Override
        public void uninstallUI(JComponent c) {
            if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
                this.header.setDefaultRenderer(this.originalHeaderRenderer);
            }
            super.uninstallUI(c);
        }

        public class XPDefaultRenderer
        extends DefaultTableCellRenderer
        implements UIResource {
            NLXPStyle.Skin skin;
            boolean isSelected;
            boolean hasFocus;
            boolean hasRollover;
            int column;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setFont(header.getFont());
                }
                this.isSelected = isSelected;
                this.hasFocus = hasFocus;
                this.column = column;
                boolean bl = this.hasRollover = column == NLTableHeaderUIXX.this.rolloverColumn;
                if (this.skin == null || this.skin.getContentMargin() == null) {
                    this.skin = NLXPStyle.getXP().getSkin(NLTableHeaderUIXX.this.header, NLTMSchema.Part.HP_HEADERITEM);
                }
                this.setText(value == null ? "" : value.toString());
                this.setBorder(new EmptyBorder(this.skin.getContentMargin()));
                return this;
            }

            private int viewIndexForColumn(TableColumn aColumn) {
                TableColumnModel cm = NLTableHeaderUIXX.this.header.getColumnModel();
                int column = 0;
                while (column < cm.getColumnCount()) {
                    if (cm.getColumn(column) == aColumn) {
                        return column;
                    }
                    ++column;
                }
                return -1;
            }

            @Override
            public void paint(Graphics g) {
                Dimension size = this.getSize();
                NLTMSchema.State state = NLTMSchema.State.NORMAL;
                if (this.column == this.viewIndexForColumn(NLTableHeaderUIXX.this.header.getDraggedColumn())) {
                    state = NLTMSchema.State.PRESSED;
                } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                    state = NLTMSchema.State.HOT;
                }
                NLTableHeaderUI.paintHeadCell(g, size);
                super.paint(g);
            }
        }
    }

    public static class RowIndexCellRenderer
    extends DefaultTableCellRenderer {
        private static TableCellRenderer single;
        private boolean selected = false;

        private RowIndexCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setIconTextGap(1);
            SwingUtils.addHandCursorStyle(this);
        }

        public static TableCellRenderer getInstance() {
            return single != null ? single : (single = new RowIndexCellRenderer());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.selected = isSelected;
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null && !isSelected) {
                    this.setForeground(new Color(195, 195, 195));
                    this.setBackground(new Color(255, 255, 255));
                }
                this.setFont(table.getFont());
            }
            this.setText(Integer.toString(row + 1));
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension size = this.getSize();
            if (this.selected) {
                int fillWidth = 2;
                int w = size.width - 1;
                int h = size.height - 1;
                g.setColor(new Color(235, 0, 0));
                g.fillRect(w - fillWidth, 0, w, h);
            }
        }
    }

    public static class RowNumHeaderView
    extends JTable {
        private JTable dependentTable;

        public RowNumHeaderView(JTable parent) {
            super(parent.getModel(), new DefaultTableColumnModel(), parent.getSelectionModel());
            TableColumn firstColumn = new TableColumn(0);
            firstColumn.setResizable(false);
            firstColumn.setCellRenderer(RowIndexCellRenderer.getInstance());
            this.getColumnModel().addColumn(firstColumn);
            this.dependentTable = parent;
            this.setCellSelectionEnabled(false);
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.setShowVerticalLines(false);
            this.setShowHorizontalLines(false);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new SearchableHeader(this.columnModel);
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
            super.scrollRectToVisible(aRect);
            this.dependentTable.scrollRectToVisible(aRect);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowHeight() {
            return this.dependentTable != null ? this.dependentTable.getRowHeight() : super.getRowHeight();
        }

        @Override
        public int getRowHeight(int row) {
            return this.dependentTable != null ? this.dependentTable.getRowHeight() : super.getRowHeight(row);
        }

        @Override
        public int getRowMargin() {
            return this.dependentTable != null ? this.dependentTable.getRowMargin() : super.getRowMargin();
        }

        class SearchableHeader
        extends JTableHeader {
            public SearchableHeader(TableColumnModel columnModel) {
                super(columnModel);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        UIAction ac = (UIAction)((ETable)RowNumHeaderView.this.dependentTable).getActionMap().get("find");
                        if (ac != null) {
                            ac.actionPerformed(null);
                        }
                    }
                });
            }

            @Override
            public void setUI(TableHeaderUI ui) {
                super.setUI(new NLTableHeaderUIXX());
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                return "\u8868\u683c\u5185\u5bb9\u67e5\u627e(\u6216Ctrl+F)...";
            }

            @Override
            public TableCellRenderer getDefaultRenderer() {
                TableCellRenderer tcr = super.getDefaultRenderer();
                if (tcr instanceof DefaultTableCellRenderer) {
                    ((DefaultTableCellRenderer)tcr).setIcon(IconFactory.getInstance().getFindSmallIcon());
                }
                return tcr;
            }
        }
    }
}

