/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.widget.EHyperLink;
import com.eva.epc.widget.EOptionPane;
import com.eva.epc.widget.res.IconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;

public class EInfoPane
extends JPanel {
    private String shortMessage;
    private JButton detailButton;
    private JButton copyButton;
    private Object detailMessage;
    private boolean showDetail = false;

    public EInfoPane(String shortMessage, Object detailMessage, boolean showDetail) {
        this.shortMessage = shortMessage;
        this.detailMessage = detailMessage;
        this.showDetail = showDetail;
        this.initGUI();
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createShortMessageBox(this.shortMessage), "North");
        if (this.showDetail) {
            this.detailButton = this.createActionButton("\u67e5\u770b\u8be6\u60c5", IconFactory.getInstance().getGrayDownIcon13_13());
            this.copyButton = this.createActionButton("\u590d\u5236\u5230\u526a\u8d34\u677f", IconFactory.getInstance().getEditCopyIcon13_13());
            JPanel detailButtonPane = new JPanel(new FlowLayout(2));
            detailButtonPane.add(this.copyButton);
            detailButtonPane.add(this.detailButton);
            JPanel detailMainPane = new JPanel(new BorderLayout());
            detailMainPane.add((Component)detailButtonPane, "North");
            JComponent[] coms = this.createDetailMessageBox(this.detailMessage);
            final JComponent sp = coms[0];
            final JComponent detailEditor = coms[1];
            sp.setBorder(BorderFactory.createEtchedBorder());
            detailMainPane.add((Component)sp, "Center");
            this.add((Component)detailMainPane, "Center");
            this.detailButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EInfoPane.this.fireDetailAction(sp);
                    ((JTextComponent)detailEditor).select(-1, -1);
                }
            });
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JTextComponent)detailEditor).copy();
                    EOptionPane.showInfoDialog_OK(EInfoPane.this, "\u590d\u5236\u6210\u529f!");
                }
            });
            this.copyButton.setVisible(false);
        }
    }

    protected JButton createActionButton(String text, Icon i) {
        EHyperLink detailButton = new EHyperLink(text, i);
        detailButton.setHorizontalTextPosition(2);
        detailButton.setIconTextGap(0);
        detailButton.setForeground(new Color(100, 100, 100));
        return detailButton;
    }

    protected JComponent[] createDetailMessageBox(Object detailMessage) {
        String dText = null;
        if (detailMessage != null) {
            dText = this.getDetailsAsHTML(detailMessage);
        }
        JEditorPane details = new JEditorPane();
        details.setContentType("text/html");
        details.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        details.setEditable(false);
        details.setTransferHandler(new DetailsTransferHandler(details));
        JScrollPane detailsScrollPane = new JScrollPane(details);
        detailsScrollPane.setPreferredSize(new Dimension(350, 250));
        detailsScrollPane.setVisible(false);
        details.setText(dText);
        return new JComponent[]{detailsScrollPane, details};
    }

    protected JComponent createShortMessageBox(String shortMessage) {
        ShortMessageBox mess = new ShortMessageBox(shortMessage != null ? shortMessage : "");
        Dimension ss = mess.getToolkit().getScreenSize();
        Dimension boxSize = new Dimension(Math.min(ss.width / 3, mess.getFontMetrics(mess.getFont()).stringWidth(mess.getText())), mess.getFont().getSize());
        mess.setSize(boxSize);
        JComponent m = mess;
        if (mess.getUI().getPreferredSize((JComponent)mess).height > ss.height / 3) {
            m = new JScrollPane(mess);
            m.setBorder(null);
            boxSize.height = ss.height / 3;
            m.setPreferredSize(boxSize);
        }
        return m;
    }

    protected void fireDetailAction(JComponent sp) {
        if (this.showDetail) {
            if (sp.isVisible()) {
                sp.setVisible(false);
                this.detailButton.setIcon(this.getDetailDownIcon());
                this.copyButton.setVisible(false);
            } else {
                sp.setVisible(true);
                this.detailButton.setIcon(this.getDetailUpIcon());
                this.copyButton.setVisible(true);
            }
            SwingUtilities.getWindowAncestor(sp).pack();
        }
    }

    protected String getDetailsAsHTML(Object detailMessage) {
        if (detailMessage != null) {
            StringBuffer html = new StringBuffer("<html>");
            if (detailMessage instanceof Throwable) {
                Throwable exx = (Throwable)detailMessage;
                if (detailMessage != null) {
                    html.append("<h3>" + detailMessage.toString() + "</h3>");
                    html.append("<HR size='1' noshade>");
                    html.append("<b>\u8be6\u7ec6\u63cf\u8ff0:</b>");
                    html.append("<br><span>" + exx.getMessage() + "</span>");
                    html.append("<pre>");
                    StackTraceElement[] stackTraceElementArray = exx.getStackTrace();
                    int n = stackTraceElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement el = stackTraceElementArray[n2];
                        html.append("    " + el.toString().replace("<init>", "&lt;init&gt;") + "\n");
                        ++n2;
                    }
                    html.append("</pre>");
                }
            } else {
                html.append("<h3>" + this.shortMessage + "</h3>");
                html.append("<HR size='1' noshade>");
                html.append("<b>\u8be6\u7ec6\u63cf\u8ff0:</b>");
                html.append("<pre>");
                html.append("    " + detailMessage.toString() + "\n");
                html.append("</pre>");
            }
            html.append("</html>");
            return html.toString();
        }
        return null;
    }

    protected Icon getDetailUpIcon() {
        return IconFactory.getInstance().getGrayUpIcon13_13();
    }

    protected Icon getDetailDownIcon() {
        return IconFactory.getInstance().getGrayDownIcon13_13();
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public void setShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
    }

    public JButton getDetailButton() {
        return this.detailButton;
    }

    public JButton getCopyButton() {
        return this.copyButton;
    }

    public Object getDetailMessage() {
        return this.detailMessage;
    }

    public void setDetailMessage(Object detailMessage) {
        this.detailMessage = detailMessage;
    }

    public boolean isShowDetail() {
        return this.showDetail;
    }

    private static final class DetailsTransferHandler
    extends TransferHandler {
        private JTextComponent details;

        private DetailsTransferHandler(JTextComponent detailComponent) {
            if (detailComponent == null) {
                throw new NullPointerException("detail component cannot be null");
            }
            this.details = detailComponent;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            String text = this.details.getSelectedText();
            if (text == null || text.equals("")) {
                this.details.selectAll();
                text = this.details.getSelectedText();
                this.details.select(-1, -1);
            }
            return new StringSelection(text);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    protected class ShortMessageBox
    extends JTextArea {
        public ShortMessageBox(String text) {
            super(text);
            this.setOpaque(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public boolean isManagingFocus() {
            return false;
        }
    }
}

