/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.file.EFileFilter;
import com.eva.epc.widget.EImageViewer;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class EImageFileChooser {
    private JFileChooser fileChooser = new JFileChooser();
    private EImageViewer imagePreviwer = new EImageViewer();

    public EImageFileChooser() {
        this.init();
    }

    protected void init() {
        this.initBase();
        this.initFileFilter();
        this.fileChooser.addPropertyChangeListener(this.createPropertyChangeListenerImpl());
    }

    protected void initBase() {
        this.fileChooser.setAccessory(this.imagePreviwer);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setCurrentDirectory(FileSystemView.getFileSystemView().getHomeDirectory());
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getFileFilter());
    }

    protected void initFileFilter() {
        this.fileChooser.addChoosableFileFilter((FileFilter)new EFileFilter("png", "PNG\u56fe\u7247(*.png)"));
        this.fileChooser.addChoosableFileFilter((FileFilter)new EFileFilter(new String[]{"jpg", "jpeg"}, "JPG\u56fe\u7247(*.jpg, *.jpeg)"));
        this.fileChooser.addChoosableFileFilter((FileFilter)new EFileFilter("gif", "GIF\u56fe\u7247(*.gif)"));
        this.fileChooser.addChoosableFileFilter((FileFilter)new EFileFilter(new String[]{"gif", "jpg", "jpeg", "png"}, "\u6240\u6709\u56fe\u7247\u7c7b\u578b(*.gif, *.jpg, *.jpeg, *.png)"));
    }

    protected PropertyChangeListener createPropertyChangeListenerImpl() {
        return new PropertyChangeListenerImpl();
    }

    protected JPanel createImageViewer() {
        return new EImageViewer();
    }

    protected void fireChoosedConfirm(File f) {
        this.imagePreviwer.setImageForView(f);
        this.imagePreviwer.setPreferredSize(new Dimension(400, 400));
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                File f = (File)e.getNewValue();
                if (f == null) {
                    return;
                }
                EImageFileChooser.this.fireChoosedConfirm(f);
            }
        }
    }
}

