/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.table;

import com.eva.epc.swingx.event.TableColumnModelExtListener;
import com.eva.epc.swingx.table.TableColumnExt;
import com.eva.epc.swingx.table.TableColumnModelExt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class DefaultTableColumnModelExt
extends DefaultTableColumnModel
implements TableColumnModelExt {
    private boolean isVisibilityChange;
    private List<TableColumn> initialColumns = new ArrayList<TableColumn>();
    private List<TableColumn> currentColumns = new ArrayList<TableColumn>();
    private VisibilityListener visibilityListener = new VisibilityListener();

    @Override
    public List<TableColumn> getColumns(boolean includeHidden) {
        if (includeHidden) {
            return new ArrayList<TableColumn>(this.initialColumns);
        }
        return Collections.list(this.getColumns());
    }

    @Override
    public int getColumnCount(boolean includeHidden) {
        if (includeHidden) {
            return this.initialColumns.size();
        }
        return this.getColumnCount();
    }

    @Override
    public TableColumnExt getColumnExt(Object identifier) {
        for (TableColumn column : this.initialColumns) {
            if (!(column instanceof TableColumnExt) || !identifier.equals(column.getIdentifier())) continue;
            return (TableColumnExt)column;
        }
        return null;
    }

    @Override
    public TableColumnExt getColumnExt(int columnIndex) {
        TableColumn column = this.getColumn(columnIndex);
        if (column instanceof TableColumnExt) {
            return (TableColumnExt)column;
        }
        return null;
    }

    public boolean isRemovedToInvisibleEvent(int oldIndex) {
        return this.isVisibilityChange;
    }

    public boolean isAddedFromInvisibleEvent(int newIndex) {
        return this.isVisibilityChange;
    }

    @Override
    public void removeColumn(TableColumn column) {
        if (column instanceof TableColumnExt) {
            ((TableColumnExt)column).removePropertyChangeListener(this.visibilityListener);
        }
        this.currentColumns.remove(column);
        this.initialColumns.remove(column);
        super.removeColumn(column);
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        boolean oldVisible = true;
        if (aColumn instanceof TableColumnExt) {
            TableColumnExt xColumn = (TableColumnExt)aColumn;
            oldVisible = xColumn.isVisible();
            xColumn.setVisible(true);
            xColumn.addPropertyChangeListener(this.visibilityListener);
        }
        this.currentColumns.add(aColumn);
        this.initialColumns.add(aColumn);
        super.addColumn(aColumn);
        if (aColumn instanceof TableColumnExt) {
            ((TableColumnExt)aColumn).setVisible(oldVisible);
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex != newIndex) {
            this.updateCurrentColumns(columnIndex, newIndex);
        }
        super.moveColumn(columnIndex, newIndex);
    }

    private void updateCurrentColumns(int oldIndex, int newIndex) {
        TableColumn movedColumn = (TableColumn)this.tableColumns.elementAt(oldIndex);
        int oldPosition = this.currentColumns.indexOf(movedColumn);
        TableColumn targetColumn = (TableColumn)this.tableColumns.elementAt(newIndex);
        int newPosition = this.currentColumns.indexOf(targetColumn);
        this.currentColumns.remove(oldPosition);
        this.currentColumns.add(newPosition, movedColumn);
    }

    protected void moveToInvisible(TableColumnExt col) {
        this.isVisibilityChange = true;
        super.removeColumn(col);
        this.isVisibilityChange = false;
    }

    protected void moveToVisible(TableColumnExt col) {
        this.isVisibilityChange = true;
        super.addColumn(col);
        Integer addIndex = this.currentColumns.indexOf(col);
        int i = 0;
        while (i < this.getColumnCount() - 1) {
            TableColumn tableCol = this.getColumn(i);
            int actualPosition = this.currentColumns.indexOf(tableCol);
            if (actualPosition > addIndex) {
                super.moveColumn(this.getColumnCount() - 1, i);
                break;
            }
            ++i;
        }
        this.isVisibilityChange = false;
    }

    public EventListenerList getEventListenerList() {
        return this.listenerList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.fireColumnPropertyChange(evt);
    }

    protected void fireColumnPropertyChange(PropertyChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TableColumnModelExtListener.class) {
                ((TableColumnModelExtListener)listeners[i + 1]).columnPropertyChange(evt);
            }
            i -= 2;
        }
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener x) {
        super.addColumnModelListener(x);
        if (x instanceof TableColumnModelExtListener) {
            this.listenerList.add(TableColumnModelExtListener.class, (TableColumnModelExtListener)x);
        }
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener x) {
        super.removeColumnModelListener(x);
        if (x instanceof TableColumnModelExtListener) {
            this.listenerList.remove(TableColumnModelExtListener.class, (TableColumnModelExtListener)x);
        }
    }

    public TableColumnModelExtListener[] getTableColumnModelExtListeners() {
        return (TableColumnModelExtListener[])this.listenerList.getListeners(TableColumnModelExtListener.class);
    }

    private class VisibilityListener
    implements PropertyChangeListener,
    Serializable {
        private VisibilityListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                TableColumnExt columnExt = (TableColumnExt)evt.getSource();
                if (columnExt.isVisible()) {
                    DefaultTableColumnModelExt.this.moveToVisible(columnExt);
                    DefaultTableColumnModelExt.this.fireColumnPropertyChange(evt);
                } else {
                    DefaultTableColumnModelExt.this.moveToInvisible(columnExt);
                }
            } else if (!((TableColumnExt)evt.getSource()).isVisible()) {
                DefaultTableColumnModelExt.this.fireColumnPropertyChange(evt);
            }
        }
    }
}

