/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx.action;

import com.eva.epc.swingx.action.Targetable;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;

public class TargetManager {
    private static TargetManager INSTANCE;
    private List<Targetable> targetList;
    private Targetable target;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public static TargetManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TargetManager();
        }
        return INSTANCE;
    }

    public void addTarget(Targetable target, boolean prepend) {
        if (this.targetList == null) {
            this.targetList = new ArrayList<Targetable>();
        }
        if (prepend) {
            this.targetList.add(0, target);
        } else {
            this.targetList.add(target);
        }
    }

    public void addTarget(Targetable target) {
        this.addTarget(target, false);
    }

    public void removeTarget(Targetable target) {
        if (this.targetList != null) {
            this.targetList.remove(target);
        }
    }

    public Targetable[] getTargets() {
        Targetable[] targets;
        if (this.targetList == null) {
            targets = new Targetable[]{};
        } else {
            targets = new Targetable[this.targetList.size()];
            targets = this.targetList.toArray(new Targetable[this.targetList.size()]);
        }
        return targets;
    }

    public void setTarget(Targetable newTarget) {
        Targetable oldTarget = this.target;
        if (oldTarget != newTarget) {
            this.target = newTarget;
            this.propertySupport.firePropertyChange("target", oldTarget, newTarget);
        }
    }

    public Targetable getTarget() {
        return this.target;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public boolean doCommand(Object command, Object value) {
        if (this.target != null && this.target.hasCommand(command) && this.target.doCommand(command, value)) {
            return true;
        }
        if (this.targetList != null) {
            for (Targetable target : this.targetList) {
                if (!target.hasCommand(command) || !target.doCommand(command, value)) continue;
                return true;
            }
        }
        ActionEvent evt = null;
        if (value instanceof ActionEvent) {
            evt = (ActionEvent)value;
        }
        Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        while (comp != null) {
            ActionMap map;
            Action action;
            if (comp instanceof JComponent && (action = (map = ((JComponent)comp).getActionMap()).get(command)) != null) {
                if (evt == null) {
                    evt = new ActionEvent(comp, 0, command.toString());
                }
                action.actionPerformed(evt);
                return true;
            }
            comp = comp.getParent();
        }
        return false;
    }

    public void reset() {
        if (this.targetList != null) {
            this.targetList.clear();
            this.targetList = null;
        }
        this.target = null;
        PropertyChangeListener[] listeners = this.propertySupport.getPropertyChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            this.propertySupport.removePropertyChangeListener(listeners[i]);
            ++i;
        }
        INSTANCE = null;
    }
}

