/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx;

import com.eva.epc.swingx.action.AbstractActionExt;
import com.eva.epc.swingx.action.ActionContainerFactory;
import com.eva.epc.swingx.icon.ColumnControlIcon;
import com.eva.epc.swingx.table.DefaultTableColumnModelExt;
import com.eva.epc.swingx.table.TableColumnExt;
import com.eva.epc.swingx.table.TableColumnModelExt;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnControlButton2
extends JButton {
    public static final String COLUMN_CONTROL_MARKER = "column.";
    public DefaultColumnControlPopup popup;
    private JTable table;
    private PropertyChangeListener tablePropertyChangeListener;
    public TableColumnModelListener columnModelListener;
    private List<ColumnVisibilityAction> columnVisibilityActions;
    public static final String PACKALL_ACTION_COMMAND = "column.packAll";
    public static final String PACKSELECTED_ACTION_COMMAND = "column.packSelected";
    private int verticalScrollPolicy;
    private boolean columnControlVisible = false;
    private boolean allActionAndItemsInited = false;

    public ColumnControlButton2(JTable table) {
        this(table, (Icon)new ColumnControlIcon());
    }

    public ColumnControlButton2(JTable table, Icon icon) {
        this.init();
        this.setAction(this.createControlAction(icon));
        this.installTable(table);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.getColumnControlPopup().updateUI();
    }

    public void togglePopup() {
        this.getColumnControlPopup().toggleVisibility(this);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.getColumnControlPopup().applyComponentOrientation(o);
    }

    public DefaultColumnControlPopup getColumnControlPopup() {
        if (this.popup == null) {
            this.popup = this.createColumnControlPopup();
        }
        return this.popup;
    }

    protected DefaultColumnControlPopup createColumnControlPopup() {
        return new DefaultColumnControlPopup();
    }

    protected void updateFromColumnModelChange(TableColumnModel oldModel) {
        if (oldModel != null) {
            oldModel.removeColumnModelListener(this.columnModelListener);
        }
        this.populatePopup();
        if (this.canControl()) {
            this.table.getColumnModel().addColumnModelListener(this.getColumnModelListener());
        }
    }

    protected void updateFromTableEnabledChanged() {
        this.getAction().setEnabled(this.table.isEnabled());
    }

    protected boolean canControl() {
        return this.table.getColumnModel() instanceof TableColumnModelExt;
    }

    protected void populatePopup() {
        this.clearAll();
        if (this.canControl()) {
            this.createVisibilityActions();
            this.addVisibilityActionItems();
        }
        this.addAdditionalActionItems();
    }

    protected void clearAll() {
        this.clearColumnVisibilityActions();
        this.getColumnControlPopup().removeAll();
    }

    protected void clearColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            return;
        }
        for (ColumnVisibilityAction action : this.columnVisibilityActions) {
            action.releaseColumn();
        }
        this.columnVisibilityActions.clear();
    }

    protected void addVisibilityActionItems() {
        this.getColumnControlPopup().addVisibilityActionItems(Collections.unmodifiableList(this.getColumnVisibilityActions()));
    }

    protected void addAdditionalActionItems() {
        this.getColumnControlPopup().addAdditionalActionItems(Collections.unmodifiableList(this.getAdditionalActions()));
    }

    protected void createVisibilityActions() {
        ArrayList<TableColumn> columns = Collections.list(this.table.getColumnModel().getColumns());
        for (TableColumn column : columns) {
            ColumnVisibilityAction action;
            if (this.isColumnHided(column) || (action = this.createColumnVisibilityAction(column)) == null) continue;
            this.getColumnVisibilityActions().add(action);
        }
    }

    protected ColumnVisibilityAction createColumnVisibilityAction(TableColumn column) {
        return new ColumnVisibilityAction(column);
    }

    public List<ColumnVisibilityAction> getColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            this.columnVisibilityActions = new ArrayList<ColumnVisibilityAction>();
        }
        return this.columnVisibilityActions;
    }

    protected List<Action> getAdditionalActions() {
        List actionKeys = this.getColumnControlActionKeys();
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Object key : actionKeys) {
            actions.add(this.table.getActionMap().get(key));
        }
        return actions;
    }

    protected List getColumnControlActionKeys() {
        Object[] allKeys = this.table.getActionMap().allKeys();
        ArrayList<Object> columnKeys = new ArrayList<Object>();
        int i = 0;
        while (i < allKeys.length) {
            if (this.isColumnControlActionKey(allKeys[i])) {
                columnKeys.add(allKeys[i]);
            }
            ++i;
        }
        Collections.sort(columnKeys);
        return columnKeys;
    }

    protected boolean isColumnControlActionKey(Object actionKey) {
        return actionKey instanceof String && ((String)actionKey).startsWith(COLUMN_CONTROL_MARKER);
    }

    private void installTable(JTable table) {
        this.table = table;
        this.initActionsAndBindings();
        table.addPropertyChangeListener(this.getTablePropertyChangeListener());
        this.updateFromTableEnabledChanged();
    }

    private void init() {
        this.setMargin(new Insets(1, 2, 2, 1));
        this.setFocusPainted(false);
        this.setFocusable(false);
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", preventHide);
        this.setToolTipText("\u8868\u683c\u5217\u663e\u793a\u63a7\u5236\u529f\u80fd.");
    }

    private Action createControlAction(Icon icon) {
        AbstractAction control = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ColumnControlButton2.this.allActionAndItemsInited) {
                    ColumnControlButton2.this.updateFromColumnModelChange(null);
                    ColumnControlButton2.this.allActionAndItemsInited = true;
                }
                ColumnControlButton2.this.togglePopup();
            }
        };
        control.putValue("SmallIcon", icon);
        return control;
    }

    protected PropertyChangeListener getTablePropertyChangeListener() {
        if (this.tablePropertyChangeListener == null) {
            this.tablePropertyChangeListener = this.createTablePropertyChangeListener();
        }
        return this.tablePropertyChangeListener;
    }

    protected PropertyChangeListener createTablePropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("columnModel".equals(evt.getPropertyName())) {
                    ColumnControlButton2.this.updateFromColumnModelChange((TableColumnModel)evt.getOldValue());
                } else if ("enabled".equals(evt.getPropertyName())) {
                    ColumnControlButton2.this.updateFromTableEnabledChanged();
                }
            }
        };
    }

    protected TableColumnModelListener getColumnModelListener() {
        if (this.columnModelListener == null) {
            this.columnModelListener = this.createColumnModelListener();
        }
        return this.columnModelListener;
    }

    protected TableColumnModelListener createColumnModelListener() {
        return new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                if (!this.isVisibilityChange(e, true)) {
                    ColumnControlButton2.this.populatePopup();
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                if (!this.isVisibilityChange(e, false)) {
                    ColumnControlButton2.this.populatePopup();
                }
            }

            private boolean isVisibilityChange(TableColumnModelEvent e, boolean added) {
                if (!(e.getSource() instanceof DefaultTableColumnModelExt)) {
                    return false;
                }
                DefaultTableColumnModelExt model = (DefaultTableColumnModelExt)e.getSource();
                if (added) {
                    return model.isAddedFromInvisibleEvent(e.getToIndex());
                }
                return model.isRemovedToInvisibleEvent(e.getFromIndex());
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    private void initActionsAndBindings() {
        ActionMap map = this.table.getActionMap();
        map.put(PACKALL_ACTION_COMMAND, this.createPackAllAction());
        map.put(PACKSELECTED_ACTION_COMMAND, this.createPackSelectedAction());
    }

    private Action createPackSelectedAction() {
        AbstractAction action = new AbstractAction("\u5e73\u94fa\u9009\u4e2d\u5217"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtils.selfAdaptingColumnWidth(ColumnControlButton2.this.table, ColumnControlButton2.this.table.getSelectedColumn());
            }
        };
        return action;
    }

    private Action createPackAllAction() {
        AbstractAction action = new AbstractAction("\u5e73\u94fa\u6240\u6709\u5217"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtils.selfAdaptingColumnWidth(ColumnControlButton2.this.table);
            }
        };
        return action;
    }

    public void unconfigureColumnControl() {
        Container gp;
        Container p = this.table.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (this.verticalScrollPolicy != 0) {
                scrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
                this.verticalScrollPolicy = 0;
            }
            if (this.isColumnControlVisible()) {
                scrollPane.setCorner("UPPER_TRAILING_CORNER", null);
            }
        }
    }

    public void configureColumnControl() {
        Container gp;
        Container p = this.table.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this.table) {
                return;
            }
            if (this.isColumnControlVisible()) {
                if (this.verticalScrollPolicy == 0) {
                    this.verticalScrollPolicy = scrollPane.getVerticalScrollBarPolicy();
                }
                scrollPane.setCorner("UPPER_TRAILING_CORNER", this);
                scrollPane.setVerticalScrollBarPolicy(22);
            }
        }
    }

    public boolean isColumnControlVisible() {
        return this.columnControlVisible;
    }

    public void setColumnControlVisible(boolean visible) {
        if (this.isColumnControlVisible() == visible) {
            return;
        }
        boolean old = this.isColumnControlVisible();
        if (old) {
            this.unconfigureColumnControl();
        }
        this.columnControlVisible = visible;
        if (this.isColumnControlVisible()) {
            this.configureColumnControl();
        }
        this.firePropertyChange("columnControlVisible", old, !old);
    }

    public boolean isColumnHided(TableColumn column) {
        return column.getMaxWidth() == 0 || column.getMinWidth() == 0 || column.getPreferredWidth() == 0;
    }

    public class ColumnVisibilityAction
    extends AbstractActionExt {
        private TableColumn column;
        private PropertyChangeListener columnListener;
        private boolean fromColumn;

        public ColumnVisibilityAction(TableColumn column) {
            super((String)null);
            this.setStateAction();
            this.installColumn(column);
        }

        public void releaseColumn() {
            this.column.removePropertyChangeListener(this.columnListener);
            this.column = null;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.canControlColumn();
        }

        protected boolean canControlColumn() {
            return this.column instanceof TableColumnExt;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.canControlColumn()) {
                if (e.getStateChange() == 2 && ColumnControlButton2.this.table.getColumnCount() <= 1 && !this.fromColumn) {
                    this.reselect();
                } else {
                    this.setSelected(e.getStateChange() == 1);
                }
            }
        }

        @Override
        public synchronized void setSelected(boolean newValue) {
            super.setSelected(newValue);
            if (this.canControlColumn()) {
                if (newValue) {
                    SwingUtils.setColumnVisible(ColumnControlButton2.this.table, ((TableColumnExt)this.column).getModelIndex(), true);
                } else {
                    SwingUtils.minimizeColumn(ColumnControlButton2.this.table, ((TableColumnExt)this.column).getModelIndex());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        private void updateFromColumnVisible(boolean visible) {
            this.fromColumn = true;
            this.setSelected(visible);
            this.fromColumn = false;
        }

        private void updateFromColumnHeader(Object value) {
            this.setName(String.valueOf(value));
        }

        private void reselect() {
            this.firePropertyChange("selected", null, Boolean.TRUE);
        }

        private void installColumn(TableColumn column) {
            this.column = column;
            column.addPropertyChangeListener(this.getColumnListener());
            this.updateFromColumnHeader(column.getHeaderValue());
            if (column.getIdentifier() != null) {
                this.setActionCommand(column.getIdentifier().toString());
            }
            boolean visible = column instanceof TableColumnExt ? ((TableColumnExt)column).isVisible() : true;
            this.updateFromColumnVisible(visible);
        }

        protected PropertyChangeListener getColumnListener() {
            if (this.columnListener == null) {
                this.columnListener = this.createPropertyChangeListener();
            }
            return this.columnListener;
        }

        protected PropertyChangeListener createPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("visible".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnVisible((Boolean)evt.getNewValue());
                    } else if ("headerValue".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnHeader(evt.getNewValue());
                    }
                }
            };
        }
    }

    public class DefaultColumnControlPopup {
        private JPopupMenu popupMenu;

        public void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.getPopupMenu());
        }

        public void toggleVisibility(JComponent owner) {
            JPopupMenu popupMenu = this.getPopupMenu();
            if (popupMenu.isVisible()) {
                popupMenu.setVisible(false);
            } else if (popupMenu.getComponentCount() > 0) {
                Dimension buttonSize = owner.getSize();
                int xPos = owner.getComponentOrientation().isLeftToRight() ? buttonSize.width - popupMenu.getPreferredSize().width : 0;
                popupMenu.show(owner, xPos, buttonSize.height);
            }
        }

        public void applyComponentOrientation(ComponentOrientation o) {
            this.getPopupMenu().applyComponentOrientation(o);
        }

        public void removeAll() {
            this.getPopupMenu().removeAll();
        }

        public void addVisibilityActionItems(List<? extends AbstractActionExt> actions) {
            this.addItems(new ArrayList<AbstractActionExt>(actions));
        }

        public void addAdditionalActionItems(List<? extends Action> actions) {
            if (actions.size() == 0) {
                return;
            }
            if (ColumnControlButton2.this.canControl()) {
                this.addSeparator();
            }
            this.addItems(actions);
        }

        protected void addItems(List<? extends Action> actions) {
            ActionContainerFactory factory = new ActionContainerFactory(null);
            for (Action action : actions) {
                this.addItem(factory.createMenuItem(action));
            }
        }

        protected void addSeparator() {
            this.getPopupMenu().addSeparator();
        }

        protected void addItem(JMenuItem item) {
            this.getPopupMenu().add(item);
        }

        public JPopupMenu getPopupMenu() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            return this.popupMenu;
        }
    }
}

