/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.lnf.winlike.WLTMSchema;
import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.awt.windows.ThemeReader;
import sun.security.action.GetPropertyAction;
import sun.swing.CachedPainter;

public class WLXPStyle {
    private static WLXPStyle xp;
    private static SkinPainter skinPainter;
    private static Boolean themeActive;
    private HashMap<String, Border> borderMap;
    private HashMap<String, Color> colorMap;
    private boolean flatMenus = WLXPStyle.getSysBoolean(WLTMSchema.Prop.FLATMENUS);

    static {
        skinPainter = new SkinPainter();
        themeActive = null;
        WLXPStyle.invalidateStyle();
    }

    static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
    }

    public static synchronized WLXPStyle getXP() {
        if (themeActive == null) {
            GetPropertyAction propertyAction;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(propertyAction = new GetPropertyAction("swing.noxp")) == null && ThemeReader.isThemed() && !(UIManager.getLookAndFeel() instanceof WindowsClassicLookAndFeel)) {
                xp = new WLXPStyle();
            }
        }
        return xp;
    }

    String getString(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop) {
        return WLXPStyle.getTypeEnumName(c, part, state, prop);
    }

    private static String getTypeEnumName(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop) {
        int enumValue = ThemeReader.getEnum((String)part.getControlName(c), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state), (int)prop.getValue());
        if (enumValue == -1) {
            return null;
        }
        return WLTMSchema.TypeEnum.getTypeEnum(prop, enumValue).getName();
    }

    int getInt(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop, int fallback) {
        return ThemeReader.getInt((String)part.getControlName(c), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    Dimension getDimension(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop) {
        return ThemeReader.getPosition((String)part.getControlName(c), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    Point getPoint(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop) {
        Dimension d = ThemeReader.getPosition((String)part.getControlName(c), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state), (int)prop.getValue());
        if (d != null) {
            return new Point(d.width, d.height);
        }
        return null;
    }

    Insets getMargin(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop) {
        return ThemeReader.getThemeMargins((String)part.getControlName(c), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    synchronized Color getColor(Skin skin, WLTMSchema.Prop prop, Color fallback) {
        String key = String.valueOf(skin.toString()) + "." + prop.name();
        WLTMSchema.Part part = skin.part;
        Color color = this.colorMap.get(key);
        if (color == null && (color = ThemeReader.getColor((String)part.getControlName(null), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, skin.state), (int)prop.getValue())) != null) {
            color = new ColorUIResource(color);
            this.colorMap.put(key, color);
        }
        return color != null ? color : fallback;
    }

    Color getColor(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop, Color fallback) {
        return this.getColor(new Skin(c, part, state), prop, fallback);
    }

    synchronized Border getBorder(Component c, WLTMSchema.Part part) {
        if (part == WLTMSchema.Part.MENU) {
            if (this.flatMenus) {
                return new XPFillBorder(UIManager.getColor("InternalFrame.borderShadow"), 1);
            }
            return null;
        }
        Skin skin = new Skin(c, part, null);
        Border border = this.borderMap.get(skin.string);
        if (border == null) {
            Insets m;
            String bgType = WLXPStyle.getTypeEnumName(c, part, null, WLTMSchema.Prop.BGTYPE);
            if ("borderfill".equalsIgnoreCase(bgType)) {
                int thickness = this.getInt(c, part, null, WLTMSchema.Prop.BORDERSIZE, 1);
                Color color = this.getColor(skin, WLTMSchema.Prop.BORDERCOLOR, Color.black);
                border = new XPFillBorder(color, thickness);
            } else if ("imagefile".equalsIgnoreCase(bgType) && (m = this.getMargin(c, part, null, WLTMSchema.Prop.SIZINGMARGINS)) != null) {
                border = this.getBoolean(c, part, null, WLTMSchema.Prop.BORDERONLY) ? new XPImageBorder(c, part) : (part == WLTMSchema.Part.TP_BUTTON ? new XPEmptyBorder(new Insets(3, 3, 3, 3)) : new XPEmptyBorder(m));
            }
            if (border != null) {
                this.borderMap.put(skin.string, border);
            }
        }
        return border;
    }

    boolean isSkinDefined(Component c, WLTMSchema.Part part) {
        return part.getValue() == 0 || ThemeReader.isThemePartDefined((String)part.getControlName(c), (int)part.getValue(), (int)0);
    }

    public synchronized Skin getSkin(Component c, WLTMSchema.Part part) {
        assert (this.isSkinDefined(c, part)) : "part " + (Object)((Object)part) + " is not defined";
        return new Skin(c, part, null);
    }

    private WLXPStyle() {
        this.colorMap = new HashMap();
        this.borderMap = new HashMap();
    }

    private boolean getBoolean(Component c, WLTMSchema.Part part, WLTMSchema.State state, WLTMSchema.Prop prop) {
        return ThemeReader.getBoolean((String)part.getControlName(c), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    private static Dimension getPartSize(WLTMSchema.Part part, WLTMSchema.State state) {
        return ThemeReader.getPartSize((String)part.getControlName(null), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state));
    }

    private static boolean getSysBoolean(WLTMSchema.Prop prop) {
        return ThemeReader.getSysBoolean((String)"window", (int)prop.getValue());
    }

    static class GlyphButton
    extends JButton {
        private Skin skin;

        public GlyphButton(Component parent, WLTMSchema.Part part) {
            WLXPStyle xp = WLXPStyle.getXP();
            this.skin = xp.getSkin(parent, part);
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        protected WLTMSchema.State getState() {
            WLTMSchema.State state = WLTMSchema.State.NORMAL;
            if (!this.isEnabled()) {
                state = WLTMSchema.State.DISABLED;
            } else if (this.getModel().isPressed()) {
                state = WLTMSchema.State.PRESSED;
            } else if (this.getModel().isRollover()) {
                state = WLTMSchema.State.HOT;
            }
            return state;
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            this.skin.paintSkin(g, 0, 0, d.width, d.height, this.getState());
        }

        public void setPart(Component parent, WLTMSchema.Part part) {
            WLXPStyle xp = WLXPStyle.getXP();
            this.skin = xp.getSkin(parent, part);
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintBorder(Graphics g) {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    public static class Skin {
        final Component component;
        final WLTMSchema.Part part;
        final WLTMSchema.State state;
        private final String string;
        private Dimension size = null;

        Skin(Component component, WLTMSchema.Part part) {
            this(component, part, null);
        }

        Skin(WLTMSchema.Part part, WLTMSchema.State state) {
            this(null, part, state);
        }

        Skin(Component component, WLTMSchema.Part part, WLTMSchema.State state) {
            this.component = component;
            this.part = part;
            this.state = state;
            String str = String.valueOf(part.getControlName(component)) + "." + part.name();
            if (state != null) {
                str = String.valueOf(str) + "(" + state.name() + ")";
            }
            this.string = str;
        }

        public Insets getContentMargin() {
            return ThemeReader.getThemeMargins((String)this.part.getControlName(null), (int)this.part.getValue(), (int)0, (int)WLTMSchema.Prop.SIZINGMARGINS.getValue());
        }

        private int getWidth(WLTMSchema.State state) {
            if (this.size == null) {
                this.size = WLXPStyle.getPartSize(this.part, state);
            }
            return this.size.width;
        }

        int getWidth() {
            return this.getWidth(this.state != null ? this.state : WLTMSchema.State.NORMAL);
        }

        private int getHeight(WLTMSchema.State state) {
            if (this.size == null) {
                this.size = WLXPStyle.getPartSize(this.part, state);
            }
            return this.size.height;
        }

        int getHeight() {
            return this.getHeight(this.state != null ? this.state : WLTMSchema.State.NORMAL);
        }

        public String toString() {
            return this.string;
        }

        public boolean equals(Object obj) {
            return obj instanceof Skin && ((Skin)obj).string.equals(this.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        void paintSkin(Graphics g, int dx, int dy, WLTMSchema.State state) {
            if (state == null) {
                state = this.state;
            }
            this.paintSkin(g, dx, dy, this.getWidth(state), this.getHeight(state), state);
        }

        void paintSkin(Graphics g, Rectangle r, WLTMSchema.State state) {
            this.paintSkin(g, r.x, r.y, r.width, r.height, state);
        }

        public void paintSkin(Graphics g, int dx, int dy, int dw, int dh, WLTMSchema.State state) {
            skinPainter.paint(null, g, dx, dy, dw, dh, new Object[]{this, state});
        }

        void paintSkin(Graphics g, int dx, int dy, int dw, int dh, WLTMSchema.State state, boolean borderFill) {
            if (borderFill && "borderfill".equals(WLXPStyle.getTypeEnumName(this.component, this.part, state, WLTMSchema.Prop.BGTYPE))) {
                return;
            }
            skinPainter.paint(null, g, dx, dy, dw, dh, new Object[]{this, state});
        }
    }

    private static class SkinPainter
    extends CachedPainter {
        SkinPainter() {
            super(30);
            this.flush();
        }

        @Override
        protected void paintToImage(Component c, Image image, Graphics g, int w, int h, Object[] args) {
            Skin skin = (Skin)args[0];
            WLTMSchema.Part part = skin.part;
            WLTMSchema.State state = (WLTMSchema.State)((Object)args[1]);
            if (state == null) {
                state = skin.state;
            }
            if (c == null) {
                c = skin.component;
            }
            WritableRaster raster = ((BufferedImage)image).getRaster();
            DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
            ThemeReader.paintBackground((int[])buffer.getData(), (String)part.getControlName(c), (int)part.getValue(), (int)WLTMSchema.State.getValue(part, state), (int)0, (int)0, (int)w, (int)h, (int)w);
        }

        @Override
        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config, Object[] args) {
            return new BufferedImage(w, h, 2);
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets m) {
            super(m.top + 2, m.left + 2, m.bottom + 2, m.right + 2);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, this.getBorderInsets());
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets = super.getBorderInsets(c, insets);
            Insets margin = null;
            if (c instanceof AbstractButton) {
                Insets m = ((AbstractButton)c).getMargin();
                if (c.getParent() instanceof JToolBar && !(c instanceof JRadioButton) && !(c instanceof JCheckBox) && m instanceof InsetsUIResource) {
                    insets.top -= 2;
                    insets.left -= 2;
                    insets.bottom -= 2;
                    insets.right -= 2;
                } else {
                    margin = m;
                }
            } else if (c instanceof JToolBar) {
                margin = ((JToolBar)c).getMargin();
            } else if (c instanceof JTextComponent) {
                margin = ((JTextComponent)c).getMargin();
            }
            if (margin != null) {
                insets.top = margin.top + 2;
                insets.left = margin.left + 2;
                insets.bottom = margin.bottom + 2;
                insets.right = margin.right + 2;
            }
            return insets;
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int thickness) {
            super(color, thickness);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            } else if (c instanceof JToolBar) {
                margin = ((JToolBar)c).getMargin();
            } else if (c instanceof JTextComponent) {
                margin = ((JTextComponent)c).getMargin();
            }
            insets.top = (margin != null ? margin.top : 0) + this.thickness;
            insets.left = (margin != null ? margin.left : 0) + this.thickness;
            insets.bottom = (margin != null ? margin.bottom : 0) + this.thickness;
            insets.right = (margin != null ? margin.right : 0) + this.thickness;
            return insets;
        }
    }

    private class XPImageBorder
    extends AbstractBorder
    implements UIResource {
        Skin skin;

        XPImageBorder(Component c, WLTMSchema.Part part) {
            this.skin = WLXPStyle.this.getSkin(c, part);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.skin.paintSkin(g, x, y, width, height, null);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            Insets borderInsets = this.skin.getContentMargin();
            if (c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            } else if (c instanceof JToolBar) {
                margin = ((JToolBar)c).getMargin();
            } else if (c instanceof JTextComponent) {
                margin = ((JTextComponent)c).getMargin();
            }
            insets.top = (margin != null ? margin.top : 0) + borderInsets.top;
            insets.left = (margin != null ? margin.left : 0) + borderInsets.left;
            insets.bottom = (margin != null ? margin.bottom : 0) + borderInsets.bottom;
            insets.right = (margin != null ? margin.right : 0) + borderInsets.right;
            return insets;
        }
    }
}

