/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.lnf.winlike.WLLookAndFeel;
import com.eva.epc.lnf.winlike.WLTMSchema;
import com.eva.epc.lnf.winlike.WLXPStyle;
import com.eva.epc.widget.ETable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import sun.swing.SwingUtilities2;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class WLTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent h) {
        return new WLTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (WLXPStyle.getXP() != null) {
            this.originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this.originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new XPDefaultRenderer());
            }
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
        if (WLXPStyle.getXP() != null) {
            this.header.repaint(this.header.getHeaderRect(oldColumn));
            this.header.repaint(this.header.getHeaderRect(newColumn));
        }
    }

    private static class IconBorder
    implements Border,
    UIResource {
        private final Icon icon;
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;

        public IconBorder(Icon icon, int top, int left, int bottom, int right) {
            this.icon = icon;
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.top, this.left, this.bottom, this.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.icon.paintIcon(c, g, x + this.left + width - this.right - this.icon.getIconWidth() - 2, y);
        }
    }

    private class XPDefaultRenderer
    extends DefaultTableCellHeaderRenderer {
        WLXPStyle.Skin skin;
        boolean isSelected;
        boolean hasFocus;
        boolean hasRollover;
        int column;

        XPDefaultRenderer() {
            this.setHorizontalAlignment(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.isSelected = isSelected;
            this.hasFocus = hasFocus;
            this.column = column;
            boolean bl = this.hasRollover = column == WLTableHeaderUI.this.getRolloverColumn() || this.getColumnSortOrder_js(table, column) != SortOrder.UNSORTED;
            if (this.skin == null) {
                this.skin = WLXPStyle.getXP().getSkin(WLTableHeaderUI.this.header, WLTMSchema.Part.HP_HEADERITEM);
            }
            Insets margins = this.skin.getContentMargin();
            Border border = null;
            int contentTop = 0;
            int contentLeft = 0;
            int contentBottom = 0;
            int contentRight = 0;
            if (margins != null) {
                contentTop = margins.top;
                contentLeft = margins.left;
                contentBottom = margins.bottom;
                contentRight = margins.right;
            }
            contentLeft += 5;
            contentBottom += 4;
            contentRight += 5;
            Icon sortIcon = this.getIcon();
            if (sortIcon instanceof UIResource || sortIcon == null) {
                this.setIcon(null);
                sortIcon = null;
                SortOrder sortOrder = this.getColumnSortOrder_js(table, column);
                if (sortOrder != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                        }
                    }
                }
                if (sortIcon != null) {
                    border = new IconBorder(sortIcon, contentTop, contentLeft, contentBottom, contentRight);
                } else {
                    sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                    int sortIconHeight = sortIcon != null ? sortIcon.getIconHeight() : 0;
                    border = new EmptyBorder(contentTop, contentLeft, contentBottom, contentRight);
                }
            } else {
                border = new EmptyBorder(contentTop += 3, contentLeft, contentBottom, contentRight);
            }
            this.setBorder(border);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            SortOrder sortOrder;
            Dimension size = this.getSize();
            WLTMSchema.State state = WLTMSchema.State.NORMAL;
            TableColumn draggedColumn = WLTableHeaderUI.this.header.getDraggedColumn();
            if (draggedColumn != null && this.column == SwingUtilities2.convertColumnIndexToView(WLTableHeaderUI.this.header.getColumnModel(), draggedColumn.getModelIndex())) {
                state = WLTMSchema.State.PRESSED;
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                state = WLTMSchema.State.HOT;
            }
            if (WLLookAndFeel.isOnVista() && (sortOrder = this.getColumnSortOrder_js(WLTableHeaderUI.this.header.getTable(), this.column)) != null) {
                block0 : switch (sortOrder) {
                    case ASCENDING: 
                    case DESCENDING: {
                        switch (state) {
                            case NORMAL: {
                                state = WLTMSchema.State.SORTEDNORMAL;
                                break block0;
                            }
                            case PRESSED: {
                                state = WLTMSchema.State.SORTEDPRESSED;
                                break block0;
                            }
                            case HOT: {
                                state = WLTMSchema.State.SORTEDHOT;
                            }
                        }
                    }
                }
            }
            this.skin.paintSkin(g, 0, 0, size.width - 1, size.height - 1, state);
            super.paint(g);
        }

        public SortOrder getColumnSortOrder_js(JTable table, int column) {
            if (table instanceof ETable) {
                SortOrder so = SortOrder.UNSORTED;
                ETable et = (ETable)table;
                if (SwingUtilities2.convertColumnIndexToModel(WLTableHeaderUI.this.header.getColumnModel(), column) == et.getSortManager().getCurrentSorttedColumn()) {
                    so = et.getSortManager().getCurrentSortOrder();
                }
                return so;
            }
            return DefaultTableCellHeaderRenderer.getColumnSortOrder(table, column);
        }
    }
}

