/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.lnf.winlike.WLTMSchema;
import com.eva.epc.lnf.winlike.WLXPStyle;
import com.eva.epc.widget.util.GraphicHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WLScrollBarUI
extends BasicScrollBarUI {
    int arc = 6;
    private Color color = new Color(178, 205, 244);

    public static ComponentUI createUI(JComponent c) {
        return new WLScrollBarUI();
    }

    protected Color getFirstTopColor() {
        return this.getColor(this.color, -1, 3, 7);
    }

    protected Color getFirstButtomColor() {
        return this.getColor(this.color, -28, -27, -18);
    }

    protected Color getSecondTopColor() {
        return this.getColor(this.color, 54, 36, 18);
    }

    protected Color getSecondButtomColor() {
        return this.getColor(this.color, 19, 13, 8);
    }

    protected Color getColor1() {
        return this.getColor(this.color, 40, 28, 17);
    }

    protected Color getColor2() {
        return this.getColor(this.color, 35, 25, 15);
    }

    protected Color getColor3() {
        return this.getColor(this.color, 10, 10, 8);
    }

    protected Color getColor4() {
        return this.getColor(this.color, -1, -1, 0);
    }

    protected Color getColor5() {
        return this.getColor(this.color, -9, -6, 2);
    }

    protected Color getColor(Color color, int r, int g, int b) {
        return new Color(this.getColorInt(color.getRed() + r), this.getColorInt(color.getGreen() + g), this.getColorInt(color.getBlue() + b));
    }

    protected int getColorInt(int rgb) {
        return rgb < 0 ? 0 : (rgb > 255 ? 255 : rgb);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (c == null || g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Paint oldp = g2.getPaint();
        int w = trackBounds.width;
        int h = trackBounds.height;
        int x = trackBounds.x;
        int y = trackBounds.y;
        if (this.scrollbar.getOrientation() == 1) {
            GradientPaint gp = new GradientPaint(x, y, GraphicHandler.getColor(this.trackColor, -15, -15, -15), w / 2, y, this.trackColor);
            g2.setPaint(gp);
            g2.fillRect(x, y, w / 2, h);
            g2.setPaint(oldp);
            g2.setColor(this.trackColor);
            g2.fillRect(w / 2, y, w / 2, h);
        } else {
            GradientPaint gp = new GradientPaint(x, y, GraphicHandler.getColor(this.trackColor, -15, -15, -15), x, h / 2, this.trackColor);
            g2.setPaint(gp);
            g2.fillRect(x, y, w, h / 2);
            g2.setPaint(oldp);
            g2.setColor(this.trackColor);
            g2.fillRect(x, h / 2, w, h);
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int w = thumbBounds.width - 4;
        int h = thumbBounds.height - 4;
        g2.translate(thumbBounds.x + 2, thumbBounds.y + 2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.scrollbar.getOrientation() == 1) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getFirstTopColor(), 0.0f, h, this.getFirstButtomColor());
            g2.setPaint(gp);
            g2.fillRoundRect(0, 0, w, h, this.arc, this.arc);
            gp = new GradientPaint(0.0f, 1.0f, this.getSecondTopColor(), 0.0f, h - 2, this.getSecondButtomColor());
            g2.setPaint(gp);
            g2.fillRoundRect(1, 1, w - 2, h - 2, this.arc, this.arc);
            g2.setColor(this.getColor1());
            g2.drawLine(3, 2, w - 5, 2);
            gp = new GradientPaint(0.0f, 4.0f, this.getColor2(), 0.0f, h / 2, this.getColor3());
            g2.setPaint(gp);
            g2.fillRect(2, 3, w - 5, h / 2 - 2);
            g2.setPaint(null);
            g2.setColor(this.getColor4());
            g2.fillRect(2, h / 2 - 2 + 3, w - 5, h - (h / 2 - 2) - 6);
            g2.setColor(this.getColor5());
            g2.drawLine(3, h - 3, w - 5, h - 3);
        } else {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getFirstTopColor(), 0.0f, h, this.getFirstButtomColor());
            g2.setPaint(gp);
            g2.fillRoundRect(0, 0, w, h, this.arc, this.arc);
            gp = new GradientPaint(0.0f, 1.0f, this.getSecondTopColor(), 0.0f, h - 2, this.getSecondButtomColor());
            g2.setPaint(gp);
            g2.fillRoundRect(1, 1, w - 2, h - 2, this.arc, this.arc);
            g2.setColor(this.getColor1());
            g2.drawLine(3, 2, w - 5, 2);
            gp = new GradientPaint(0.0f, 4.0f, this.getColor2(), 0.0f, h / 2, this.getColor3());
            g2.setPaint(gp);
            g2.fillRect(2, 3, w - 5, h / 2 - 2);
            g2.setPaint(null);
            g2.setColor(this.getColor4());
            g2.fillRect(2, h / 2 - 2 + 3, w - 5, h - (h / 2 - 2) - 6);
            g2.setColor(this.getColor5());
            g2.drawLine(3, h - 3, w - 5, h - 3);
        }
        g2.translate(-thumbBounds.x, -thumbBounds.y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private class WindowsArrowButton
    extends BasicArrowButton {
        public WindowsArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
        }

        public WindowsArrowButton(int direction) {
            super(direction);
        }

        @Override
        public void paint(Graphics g) {
            WLXPStyle xp = WLXPStyle.getXP();
            if (xp != null) {
                ButtonModel model = this.getModel();
                WLXPStyle.Skin skin = xp.getSkin(WLScrollBarUI.this.scrollbar, WLTMSchema.Part.SBP_ARROWBTN);
                WLTMSchema.State state = null;
                if (model.isArmed() && model.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = WLTMSchema.State.UPPRESSED;
                            break;
                        }
                        case 5: {
                            state = WLTMSchema.State.DOWNPRESSED;
                            break;
                        }
                        case 7: {
                            state = WLTMSchema.State.LEFTPRESSED;
                            break;
                        }
                        case 3: {
                            state = WLTMSchema.State.RIGHTPRESSED;
                        }
                    }
                } else if (!model.isEnabled()) {
                    switch (this.direction) {
                        case 1: {
                            state = WLTMSchema.State.UPDISABLED;
                            break;
                        }
                        case 5: {
                            state = WLTMSchema.State.DOWNDISABLED;
                            break;
                        }
                        case 7: {
                            state = WLTMSchema.State.LEFTDISABLED;
                            break;
                        }
                        case 3: {
                            state = WLTMSchema.State.RIGHTDISABLED;
                        }
                    }
                } else if (model.isRollover() || model.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = WLTMSchema.State.UPHOT;
                            break;
                        }
                        case 5: {
                            state = WLTMSchema.State.DOWNHOT;
                            break;
                        }
                        case 7: {
                            state = WLTMSchema.State.LEFTHOT;
                            break;
                        }
                        case 3: {
                            state = WLTMSchema.State.RIGHTHOT;
                        }
                    }
                } else {
                    switch (this.direction) {
                        case 1: {
                            state = WLTMSchema.State.UPNORMAL;
                            break;
                        }
                        case 5: {
                            state = WLTMSchema.State.DOWNNORMAL;
                            break;
                        }
                        case 7: {
                            state = WLTMSchema.State.LEFTNORMAL;
                            break;
                        }
                        case 3: {
                            state = WLTMSchema.State.RIGHTNORMAL;
                        }
                    }
                }
                skin.paintSkin(g, 0, 0, this.getWidth(), this.getHeight(), state);
            } else {
                super.paint(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int size = 16;
            if (WLScrollBarUI.this.scrollbar != null) {
                switch (WLScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        size = WLScrollBarUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        size = WLScrollBarUI.this.scrollbar.getHeight();
                    }
                }
                size = Math.max(size, 5);
            }
            return new Dimension(size, size);
        }
    }
}

