/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.widget.util.GraphicHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class WLMetalBorders {
    static Object NO_BUTTON_ROLLOVER = new StringBuffer("NoButtonRollover");
    public static final int GUESS_TITLE_PANE_HEIGHT = 25;

    static class DialogBorder
    extends AbstractBorder
    implements UIResource {
        public static Insets insets = new Insets(4, 4, 4, 4);

        DialogBorder() {
        }

        protected Color getActiveBackground() {
            return MetalLookAndFeel.getPrimaryControlDarkShadow();
        }

        protected Color getActiveHighlight() {
            return MetalLookAndFeel.getPrimaryControlShadow();
        }

        protected Color getActiveShadow() {
            return MetalLookAndFeel.getPrimaryControlInfo();
        }

        protected Color getInactiveBackground() {
            return MetalLookAndFeel.getControlDarkShadow();
        }

        protected Color getInactiveHighlight() {
            return MetalLookAndFeel.getControlShadow();
        }

        protected Color getInactiveShadow() {
            return MetalLookAndFeel.getControlInfo();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color highlight;
            Color background;
            boolean selected = false;
            if (c instanceof JInternalFrame) {
                selected = ((JInternalFrame)c).isSelected();
            } else {
                Window window = SwingUtilities.getWindowAncestor(c);
                boolean bl = selected = window != null && window.isActive();
            }
            if (selected) {
                background = UIManager.getColor("activeCaptionBorder");
                highlight = UIManager.getColor("activeCaption");
            } else {
                background = UIManager.getColor("inactiveCaptionBorder");
                highlight = UIManager.getColor("inactiveCaption");
            }
            FrameBorder.frameBorderPaintImpl(g, x, y, w, h, DialogBorder.insets.left, background, highlight);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = DialogBorder.insets.top;
            newInsets.left = DialogBorder.insets.left;
            newInsets.bottom = DialogBorder.insets.bottom;
            newInsets.right = DialogBorder.insets.right;
            return newInsets;
        }
    }

    static class ErrorDialogBorder
    extends OptionDialogBorder {
        ErrorDialogBorder() {
        }

        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.errorDialog.border.background");
        }
    }

    static class FrameBorder
    extends AbstractBorder
    implements UIResource {
        public static final Insets insets = new Insets(4, 4, 4, 4);

        FrameBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color highlight;
            Color background;
            Window window = SwingUtilities.getWindowAncestor(c);
            if (window != null && window.isActive()) {
                background = UIManager.getColor("activeCaptionBorder");
                highlight = UIManager.getColor("activeCaption");
            } else {
                background = UIManager.getColor("inactiveCaptionBorder");
                highlight = UIManager.getColor("inactiveCaption");
            }
            FrameBorder.frameBorderPaintImpl(g, x, y, w, h, FrameBorder.insets.left, background, highlight);
        }

        public static void frameBorderPaintImpl(Graphics g, int x, int y, int w, int h, int thickness, Color background, Color highlight) {
            GradientPaint gp;
            Graphics2D g2 = (Graphics2D)g;
            Paint oldpaint = g2.getPaint();
            if (thickness >= 1) {
                gp = new GradientPaint(x, y, GraphicHandler.getColor(background, -40, -40, -40), x, 25.0f, background);
                g2.setPaint(gp);
                g2.drawRect(x, y, w - 1, h - 1);
            }
            if (thickness >= 2) {
                gp = new GradientPaint(x, y, GraphicHandler.getColor(background, 110, 110, 110), x, 25.0f, GraphicHandler.getColor(background, 10, 10, 10));
                g2.setPaint(gp);
                g2.drawRect(x + 1, y + 1, w - 3, h - 3);
            }
            if (thickness >= 3) {
                gp = new GradientPaint(x, y, GraphicHandler.getColor(background, 50, 50, 50), x, 25.0f, GraphicHandler.getColor(highlight, -20, -20, -20));
                g2.setPaint(gp);
                g2.drawRect(x + 2, y + 2, w - 5, h - 5);
            }
            if (thickness >= 4) {
                gp = new GradientPaint(x, y, highlight, x, 25.0f, GraphicHandler.getColor(highlight, -20, -20, -20));
                g2.setPaint(gp);
                g2.drawRect(x + 3, y + 3, w - 7, h - 7);
            }
            g2.setPaint(oldpaint);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = FrameBorder.insets.top;
            newInsets.left = FrameBorder.insets.left;
            newInsets.bottom = FrameBorder.insets.bottom;
            newInsets.right = FrameBorder.insets.right;
            return newInsets;
        }
    }

    static class InternalFrameDialogBorder
    extends DialogBorder {
        public InternalFrameDialogBorder() {
            insets = new Insets(3, 3, 3, 3);
        }
    }

    static class InternalFrameQuestionDialogBorder
    extends QuestionDialogBorder {
        public InternalFrameQuestionDialogBorder() {
            insets = new Insets(3, 3, 3, 3);
        }
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        public static Insets insets = new Insets(3, 3, 3, 3);
        int titleHeight = 0;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color borderColor;
            Object obj;
            g.translate(x, y);
            int messageType = -1;
            if (c instanceof JInternalFrame && (obj = ((JInternalFrame)c).getClientProperty("JInternalFrame.messageType")) != null && obj instanceof Integer) {
                messageType = (Integer)obj;
            }
            switch (messageType) {
                case 0: {
                    borderColor = UIManager.getColor("OptionPane.errorDialog.border.background");
                    break;
                }
                case 3: {
                    borderColor = UIManager.getColor("OptionPane.questionDialog.border.background");
                    break;
                }
                case 2: {
                    borderColor = UIManager.getColor("OptionPane.warningDialog.border.background");
                    break;
                }
                default: {
                    borderColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
                }
            }
            FrameBorder.frameBorderPaintImpl(g, x, y, w, h, OptionDialogBorder.insets.left, borderColor, GraphicHandler.getColor(borderColor, 50, 50, 50));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = OptionDialogBorder.insets.top;
            newInsets.left = OptionDialogBorder.insets.left;
            newInsets.bottom = OptionDialogBorder.insets.bottom;
            newInsets.right = OptionDialogBorder.insets.right;
            return newInsets;
        }
    }

    static class QuestionDialogBorder
    extends OptionDialogBorder {
        QuestionDialogBorder() {
        }

        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.questionDialog.border.background");
        }
    }

    static class WarningDialogBorder
    extends OptionDialogBorder {
        WarningDialogBorder() {
        }
    }
}

