/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import com.eva.epc.lnf.nimbuslike.NL9IconFactory;
import com.eva.epc.lnf.nimbuslike.NLTMSchema;
import com.eva.epc.lnf.nimbuslike.NLXPStyle;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class NLWindowsButtonUI
extends BasicButtonUI {
    private static final NLWindowsButtonUI xWindowsButtonUI = new NLWindowsButtonUI();
    private NormalColor nomalColor = NormalColor.gray;
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean defaults_initialized = false;

    public NLWindowsButtonUI setNormalColor(NormalColor nc) {
        this.nomalColor = nc;
        return this;
    }

    public static ComponentUI createUI(JComponent c) {
        return xWindowsButtonUI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        NLXPStyle xp;
        super.installDefaults(b);
        b.setOpaque(false);
        if (!this.defaults_initialized) {
            String pp = this.getPropertyPrefix();
            this.dashedRectGapX = UIManager.getInt(String.valueOf(pp) + "dashedRectGapX");
            this.dashedRectGapY = UIManager.getInt(String.valueOf(pp) + "dashedRectGapY");
            this.dashedRectGapWidth = UIManager.getInt(String.valueOf(pp) + "dashedRectGapWidth");
            this.dashedRectGapHeight = UIManager.getInt(String.valueOf(pp) + "dashedRectGapHeight");
            this.focusColor = UIManager.getColor(String.valueOf(pp) + "focus");
            this.defaults_initialized = true;
        }
        if ((xp = NLXPStyle.getXP()) != null) {
            b.setBorder(xp.getBorder(b, NLWindowsButtonUI.getXPButtonType(b)));
            LookAndFeel.installProperty(b, "rolloverEnabled", Boolean.TRUE);
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        WindowsGraphicsUtils.paintText((Graphics)g, (AbstractButton)b, (Rectangle)textRect, (String)text, (int)this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        if (NLXPStyle.getXP() != null) {
            return;
        }
        int width = b.getWidth();
        int height = b.getHeight();
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, this.dashedRectGapX, this.dashedRectGapY, width - this.dashedRectGapWidth, height - this.dashedRectGapHeight);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        AbstractButton b = (AbstractButton)c;
        if (d != null && b.isFocusPainted()) {
            if (d.width % 2 == 0) {
                ++d.width;
            }
            if (d.height % 2 == 0) {
                ++d.height;
            }
        }
        return d;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (NLXPStyle.getXP() != null) {
            this.paintXPButtonBackground(g, c);
        }
        super.paint(g, c);
    }

    static NLTMSchema.Part getXPButtonType(AbstractButton b) {
        boolean toolbar = b.getParent() instanceof JToolBar;
        return toolbar ? NLTMSchema.Part.TP_BUTTON : NLTMSchema.Part.BP_PUSHBUTTON;
    }

    void paintXPButtonBackground(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        NLXPStyle xp = NLXPStyle.getXP();
        boolean toolbar = b.getParent() instanceof JToolBar;
        NLTMSchema.Part part = NLWindowsButtonUI.getXPButtonType(b);
        if (b.isContentAreaFilled() && xp != null) {
            ButtonModel model = b.getModel();
            NLXPStyle.Skin skin = xp.getSkin(b, part);
            NLTMSchema.State state = NLTMSchema.State.NORMAL;
            if (toolbar) {
                if (model.isArmed() && model.isPressed()) {
                    state = NLTMSchema.State.PRESSED;
                } else if (!model.isEnabled()) {
                    state = NLTMSchema.State.DISABLED;
                } else if (model.isSelected() && model.isRollover()) {
                    state = NLTMSchema.State.HOTCHECKED;
                } else if (model.isSelected()) {
                    state = NLTMSchema.State.CHECKED;
                } else if (model.isRollover()) {
                    state = NLTMSchema.State.HOT;
                }
            } else if (model.isArmed() && model.isPressed() || model.isSelected()) {
                state = NLTMSchema.State.PRESSED;
            } else if (!model.isEnabled()) {
                state = NLTMSchema.State.DISABLED;
            } else if (model.isRollover() || model.isPressed()) {
                state = NLTMSchema.State.HOT;
            } else if (b instanceof JButton && ((JButton)b).isDefaultButton()) {
                state = NLTMSchema.State.DEFAULTED;
            } else if (c.hasFocus()) {
                state = NLTMSchema.State.HOT;
            }
            Dimension d = c.getSize();
            int dx = 0;
            int dy = 0;
            int dw = d.width;
            int dh = d.height;
            Border border = c.getBorder();
            Insets insets = border != null ? NLWindowsButtonUI.getOpaqueInsets(border, c) : c.getInsets();
            if (insets != null) {
                dx += insets.left;
                dy += insets.top;
                dw -= insets.left + insets.right;
                dh -= insets.top + insets.bottom;
            }
            if (toolbar) {
                skin.paintSkin(g, dx, dy, dw, dh, state);
            } else {
                try {
                    if (state == NLTMSchema.State.PRESSED) {
                        NL9IconFactory.getInstance().getButtonIcon_PressedOrange().draw((Graphics2D)g, dx, dy, dw, dh);
                    } else if (this.nomalColor == NormalColor.green) {
                        if (state == NLTMSchema.State.DISABLED) {
                            NL9IconFactory.getInstance().getButtonIcon_DisableGray().draw((Graphics2D)g, dx, dy, dw, dh);
                        } else {
                            NL9IconFactory.getInstance().getButtonIcon_NormalGreen().draw((Graphics2D)g, dx, dy, dw, dh);
                        }
                    } else if (this.nomalColor == NormalColor.red) {
                        if (state == NLTMSchema.State.DISABLED) {
                            NL9IconFactory.getInstance().getButtonIcon_NormalGray().draw((Graphics2D)g, dx, dy, dw, dh);
                        } else {
                            NL9IconFactory.getInstance().getButtonIcon_NormalRed().draw((Graphics2D)g, dx, dy, dw, dh);
                        }
                    } else {
                        NL9IconFactory.getInstance().getButtonIcon_NormalGray().draw((Graphics2D)g, dx, dy, dw, dh);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Insets getOpaqueInsets(Border b, Component c) {
        if (b == null) {
            return null;
        }
        if (b.isBorderOpaque()) {
            return b.getBorderInsets(c);
        }
        if (b instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)b;
            Insets iOut = NLWindowsButtonUI.getOpaqueInsets(cb.getOutsideBorder(), c);
            if (iOut != null && iOut.equals(cb.getOutsideBorder().getBorderInsets(c))) {
                Insets iIn = NLWindowsButtonUI.getOpaqueInsets(cb.getInsideBorder(), c);
                if (iIn == null) {
                    return iOut;
                }
                return new Insets(iOut.top + iIn.top, iOut.left + iIn.left, iOut.bottom + iIn.bottom, iOut.right + iIn.right);
            }
            return iOut;
        }
        return null;
    }

    public static enum NormalColor {
        gray,
        green,
        red;

    }
}

