/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class NLSeparatorUI
extends SeparatorUI {
    protected Color shadow;
    protected Color highlight;
    protected Color linectColor = new Color(64, 64, 64, 200);
    protected Color linebtColor = new Color(200, 230, 255);
    protected float divf = 0.6f;
    protected float linethick = 0.06666667f;

    public static ComponentUI createUI(JComponent c) {
        return new NLSeparatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.installDefaults((JSeparator)c);
        this.installListeners((JSeparator)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults((JSeparator)c);
        this.uninstallListeners((JSeparator)c);
    }

    protected void installDefaults(JSeparator s) {
        LookAndFeel.installColors(s, "Separator.background", "Separator.foreground");
        LookAndFeel.installProperty(s, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(JSeparator s) {
    }

    protected void installListeners(JSeparator s) {
    }

    protected void uninstallListeners(JSeparator s) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        if (((JSeparator)c).getOrientation() == 1) {
            g.setColor(c.getForeground());
            g.drawLine(0, 0, 0, c.getHeight());
            g.setColor(c.getBackground());
            g.drawLine(1, 0, 1, c.getHeight());
        } else {
            this.drawHorizonal(g2, c, w, h);
        }
    }

    private void drawHorizonal(Graphics2D g2, JComponent c, int w, int h) {
        Color color = c.getBackground();
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 250);
        Rectangle rect = new Rectangle(0, (int)(this.divf * (float)h), w, (int)((1.0f - this.divf) * (float)h));
        int lheight = (int)this.linethick;
        Rectangle rectline = new Rectangle(rect.x, rect.y, rect.width, lheight < 1 ? 1 : lheight);
        g2.setColor(this.linectColor);
        g2.setClip(rectline);
        g2.fill(rectline);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color, w / 2, 0.0f, new Color(this.linebtColor.getRed(), this.linebtColor.getGreen(), this.linebtColor.getBlue(), 0));
        g2.setPaint(gp);
        g2.fillRect(rectline.x, rectline.y, rectline.width, rectline.height);
        gp = new GradientPaint((int)(0.96f * (float)w), 0.0f, color, w / 2, 0.0f, new Color(this.linebtColor.getRed(), this.linebtColor.getGreen(), this.linebtColor.getBlue(), 0));
        g2.setPaint(gp);
        g2.fillRect(rectline.x, rectline.y, rectline.width, rectline.height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(2, 0);
        }
        return new Dimension(0, 3);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        JFrame f = new JFrame("111");
        f.setBounds(100, 100, 200, 200);
        JToolBar.Separator sp = new JToolBar.Separator(new Dimension(3, 100));
        sp.setUI(new NLSeparatorUI());
        sp.setOrientation(1);
        f.getContentPane().setLayout(new FlowLayout());
        f.getContentPane().add(new JButton("ddddd"));
        f.getContentPane().add(sp);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

