/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import com.eva.epc.lnf.nimbuslike.NLLabelUI;
import com.eva.epc.widget.util.GraphicHandler;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class NLPanelUI
extends BasicPanelUI {
    private static PanelUI panelUI;
    private Color backgroundColor;
    private boolean useTextureFill = false;

    public NLPanelUI() {
        this(UIManager.getColor("Panel.background"));
    }

    public NLPanelUI(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public NLPanelUI(boolean useTextureFill) {
        this(null, useTextureFill);
    }

    public NLPanelUI(Color backgroundColor, boolean useTextureFill) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
        this.useTextureFill = useTextureFill;
    }

    public static ComponentUI createUI(JComponent c, Color backgroundColor, boolean useTextureFill) {
        return new NLLabelUI(backgroundColor, useTextureFill);
    }

    public static ComponentUI createUI(JComponent c) {
        if (panelUI == null) {
            panelUI = new NLPanelUI();
        }
        return panelUI;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c == null || g == null) {
            return;
        }
        Rectangle thumbBounds = c.getBounds();
        Graphics2D g2 = (Graphics2D)g;
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        NLPanelUI.paintBg(g2, w, h);
    }

    protected Color getColor(int r, int g, int b) {
        return GraphicHandler.getColor(this.backgroundColor, r, g, b);
    }

    public static void paintBg(Graphics2D g2, int w, int h) {
        SwingUtils.setAntiAliasing(g2, true);
        Paint oldpaint = g2.getPaint();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, new Color(241, 241, 241), 0.0f, h, new Color(226, 226, 226));
        g2.setPaint(gp);
        g2.fillRect(0, 0, w, h);
        g2.setPaint(oldpaint);
        SwingUtils.setAntiAliasing(g2, false);
    }
}

