/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import com.eva.epc.lnf.nimbuslike.NL9IconFactory;
import com.eva.epc.lnf.nimbuslike.NLMenuItemUIAccessor;
import com.eva.epc.lnf.nimbuslike.NLTMSchema;
import com.eva.epc.lnf.nimbuslike.NLUtils;
import com.eva.epc.lnf.nimbuslike.NLXPStyle;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class NLMenuItemUI
extends WindowsMenuItemUI {
    private static boolean enforceTransparent = true;
    final NLMenuItemUIAccessor accessor = new NLMenuItemUIAccessor(){

        @Override
        public JMenuItem getMenuItem() {
            return NLMenuItemUI.this.menuItem;
        }

        @Override
        public NLTMSchema.State getState(JMenuItem menuItem) {
            return NLMenuItemUI.getState(this, menuItem);
        }

        @Override
        public NLTMSchema.Part getPart(JMenuItem menuItem) {
            return NLMenuItemUI.getPart(this, menuItem);
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new NLMenuItemUI();
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (NLMenuItemUI.isVistaPainting()) {
            NLMenuItemUI.paintBackground(this.accessor, g, menuItem, bgColor);
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            try {
                NL9IconFactory.getInstance().getBgIcon_ItemSelected().draw(g2, 0, 0, menuWidth, menuHeight);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!enforceTransparent) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }

    static void paintBackground(NLMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Color bgColor) {
        assert (NLMenuItemUI.isVistaPainting());
        if (NLMenuItemUI.isVistaPainting()) {
            int menuWidth = menuItem.getWidth();
            int menuHeight = menuItem.getHeight();
            if (menuItem.isOpaque()) {
                Color oldColor = g.getColor();
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
                g.setColor(oldColor);
            }
            NLXPStyle xp = NLXPStyle.getXP();
            NLTMSchema.Part part = menuItemUI.getPart(menuItem);
            NLXPStyle.Skin skin = xp.getSkin(menuItem, part);
            skin.paintSkin(g, 0, 0, menuWidth, menuHeight, menuItemUI.getState(menuItem));
        }
    }

    static void paintText(NLMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        assert (NLMenuItemUI.isVistaPainting());
        if (NLMenuItemUI.isVistaPainting()) {
            NLTMSchema.State state = menuItemUI.getState(menuItem);
            FontMetrics fm = NLUtils.getFontMetrics(menuItem, g);
            int mnemIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemIndex = -1;
            }
            NLXPStyle xp = NLXPStyle.getXP();
            Color textColor = menuItem.getForeground();
            if (textColor instanceof UIResource) {
                NLTMSchema.Part part = menuItemUI.getPart(menuItem);
                textColor = xp.getColor(menuItem, part, state, NLTMSchema.Prop.TEXTCOLOR, textColor);
            }
            g.setColor(textColor);
            NLUtils.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    static NLTMSchema.State getState(NLMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        ButtonModel model = menuItem.getModel();
        NLTMSchema.State state = model.isArmed() ? (model.isEnabled() ? NLTMSchema.State.HOT : NLTMSchema.State.DISABLEDHOT) : (model.isEnabled() ? NLTMSchema.State.NORMAL : NLTMSchema.State.DISABLED);
        return state;
    }

    static NLTMSchema.Part getPart(NLMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        return NLTMSchema.Part.MP_POPUPITEM;
    }

    static boolean isVistaPainting() {
        NLXPStyle xp = NLXPStyle.getXP();
        return xp != null && xp.isSkinDefined(null, NLTMSchema.Part.MP_POPUPITEM);
    }

    public static boolean isEnforceTransparent() {
        return enforceTransparent;
    }

    public static void setEnforceTransparent(boolean enforceTransparent) {
        NLMenuItemUI.enforceTransparent = enforceTransparent;
    }
}

