/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Timer;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.core.LocalDataSender;
import net.x52im.mobileimsdk.java.utils.Log;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QoS4SendDaemon {
    private static final String TAG = QoS4SendDaemon.class.getSimpleName();
    private static QoS4SendDaemon instance = null;
    public static final int CHECH_INTERVAL = 5000;
    public static final int MESSAGES_JUST$NOW_TIME = 3000;
    public static final int QOS_TRY_COUNT = 2;
    private ConcurrentHashMap<String, Protocal> sentMessages = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> sendMessagesTimestamp = new ConcurrentHashMap();
    private boolean running = false;
    private boolean _excuting = false;
    private Timer timer = null;

    public static QoS4SendDaemon getInstance() {
        if (instance == null) {
            instance = new QoS4SendDaemon();
        }
        return instance;
    }

    private QoS4SendDaemon() {
        this.init();
    }

    private void init() {
        this.timer = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QoS4SendDaemon.this.run();
            }
        });
    }

    public void run() {
        if (!this._excuting) {
            ArrayList<Protocal> lostMessages = new ArrayList<Protocal>();
            this._excuting = true;
            try {
                if (ClientCoreSDK.DEBUG) {
                    Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011=========== \u6d88\u606f\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u7ebf\u7a0b\u8fd0\u884c\u4e2d, \u5f53\u524d\u9700\u8981\u5904\u7406\u7684\u5217\u8868\u957f\u5ea6\u4e3a" + this.sentMessages.size() + "...");
                }
                for (String key : this.sentMessages.keySet()) {
                    Protocal p = this.sentMessages.get(key);
                    if (p != null && p.isQoS()) {
                        if (p.getRetryCount() >= 2) {
                            if (ClientCoreSDK.DEBUG) {
                                Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6307\u7eb9\u4e3a" + p.getFp() + "\u7684\u6d88\u606f\u5305\u91cd\u4f20\u6b21\u6570\u5df2\u8fbe" + p.getRetryCount() + "(\u6700\u591a" + 2 + "\u6b21)\u4e0a\u9650\uff0c\u5c06\u5224\u5b9a\u4e3a\u4e22\u5305\uff01");
                            }
                            lostMessages.add((Protocal)p.clone());
                            this.remove(p.getFp());
                            continue;
                        }
                        Long sendMessageTimestamp = this.sendMessagesTimestamp.get(key);
                        long delta = System.currentTimeMillis() - (sendMessageTimestamp == null ? 0L : sendMessageTimestamp);
                        if (delta <= 3000L) {
                            if (!ClientCoreSDK.DEBUG) continue;
                            Log.w(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6307\u7eb9\u4e3a" + key + "\u7684\u5305\u8ddd\"\u521a\u521a\"\u53d1\u51fa\u624d" + delta + "ms(<=" + 3000 + "ms\u5c06\u88ab\u8ba4\u5b9a\u662f\"\u521a\u521a\"), \u672c\u6b21\u4e0d\u9700\u8981\u91cd\u4f20\u54e6.");
                            continue;
                        }
                        new LocalDataSender.SendCommonDataAsync(p){

                            protected void onPostExecute(Integer code) {
                                if (code == 0) {
                                    this.p.increaseRetryCount();
                                    if (ClientCoreSDK.DEBUG) {
                                        Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6307\u7eb9\u4e3a" + this.p.getFp() + "\u7684\u6d88\u606f\u5305\u5df2\u6210\u529f\u8fdb\u884c\u91cd\u4f20\uff0c\u6b64\u6b21\u4e4b\u540e\u91cd\u4f20\u6b21\u6570\u5df2\u8fbe" + this.p.getRetryCount() + "(\u6700\u591a" + 2 + "\u6b21).");
                                    }
                                } else {
                                    Log.w(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6307\u7eb9\u4e3a" + this.p.getFp() + "\u7684\u6d88\u606f\u5305\u91cd\u4f20\u5931\u8d25\uff0c\u5b83\u7684\u91cd\u4f20\u6b21\u6570\u4e4b\u524d\u5df2\u7d2f\u8ba1\u4e3a" + this.p.getRetryCount() + "(\u6700\u591a" + 2 + "\u6b21).");
                                }
                            }
                        }.execute();
                        continue;
                    }
                    this.remove(key);
                }
            }
            catch (Exception eee) {
                Log.w(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6d88\u606f\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u7ebf\u7a0b\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38," + eee.getMessage(), eee);
            }
            if (lostMessages != null && lostMessages.size() > 0) {
                this.notifyMessageLost(lostMessages);
            }
            this._excuting = false;
        }
    }

    protected void notifyMessageLost(ArrayList<Protocal> lostMessages) {
        if (ClientCoreSDK.getInstance().getMessageQoSEvent() != null) {
            ClientCoreSDK.getInstance().getMessageQoSEvent().messagesLost(lostMessages);
        }
    }

    public void startup(boolean immediately) {
        this.stop();
        if (immediately) {
            this.timer.setInitialDelay(0);
        } else {
            this.timer.setInitialDelay(5000);
        }
        this.timer.start();
        this.running = true;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    boolean exist(String fingerPrint) {
        return this.sentMessages.get(fingerPrint) != null;
    }

    public void put(Protocal p) {
        if (p == null) {
            Log.w(TAG, "Invalid arg p==null.");
            return;
        }
        if (p.getFp() == null) {
            Log.w(TAG, "Invalid arg p.getFp() == null.");
            return;
        }
        if (!p.isQoS()) {
            Log.w(TAG, "This protocal is not QoS pkg, ignore it!");
            return;
        }
        if (this.sentMessages.get(p.getFp()) != null) {
            Log.w(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6307\u7eb9\u4e3a" + p.getFp() + "\u7684\u6d88\u606f\u5df2\u7ecf\u653e\u5165\u4e86\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u961f\u5217\uff0c\u8be5\u6d88\u606f\u4e3a\u4f55\u4f1a\u91cd\u590d\uff1f\uff08\u751f\u6210\u7684\u6307\u7eb9\u7801\u91cd\u590d\uff1f\u8fd8\u662f\u91cd\u590dput\uff1f\uff09");
        }
        this.sentMessages.put(p.getFp(), p);
        this.sendMessagesTimestamp.put(p.getFp(), System.currentTimeMillis());
    }

    public void remove(final String fingerPrint) {
        new SwingWorker<Protocal, Object>(){

            protected Protocal doInBackground() {
                QoS4SendDaemon.this.sendMessagesTimestamp.remove(fingerPrint);
                return (Protocal)QoS4SendDaemon.this.sentMessages.remove(fingerPrint);
            }

            protected void done() {
                Protocal result = null;
                try {
                    result = (Protocal)this.get();
                }
                catch (Exception e) {
                    Log.w(TAG, e.getMessage());
                }
                Log.w(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6307\u7eb9\u4e3a" + fingerPrint + "\u7684\u6d88\u606f\u5df2\u6210\u529f\u4ece\u53d1\u9001\u8d28\u91cf\u4fdd\u8bc1\u961f\u5217\u4e2d\u79fb\u9664(\u53ef\u80fd\u662f\u6536\u5230\u63a5\u6536\u65b9\u7684\u5e94\u7b54\u4e5f\u53ef\u80fd\u662f\u8fbe\u5230\u4e86\u91cd\u4f20\u7684\u6b21\u6570\u4e0a\u9650)\uff0c\u91cd\u8bd5\u6b21\u6570=" + (result != null ? Integer.valueOf(result.getRetryCount()) : "none\u5475\u5475."));
            }
        }.execute();
    }

    public void clear() {
        this.sentMessages.clear();
        this.sendMessagesTimestamp.clear();
    }

    public int size() {
        return this.sentMessages.size();
    }
}

