/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Timer;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.utils.Log;
import net.x52im.mobileimsdk.server.protocal.Protocal;

public class QoS4ReciveDaemon {
    private static final String TAG = QoS4ReciveDaemon.class.getSimpleName();
    private static QoS4ReciveDaemon instance = null;
    public static final int CHECH_INTERVAL = 300000;
    public static final int MESSAGES_VALID_TIME = 600000;
    private ConcurrentHashMap<String, Long> recievedMessages = new ConcurrentHashMap();
    private boolean running = false;
    private boolean _excuting = false;
    private Timer timer = null;

    public static QoS4ReciveDaemon getInstance() {
        if (instance == null) {
            instance = new QoS4ReciveDaemon();
        }
        return instance;
    }

    public QoS4ReciveDaemon() {
        this.init();
    }

    private void init() {
        this.timer = new Timer(300000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QoS4ReciveDaemon.this.run();
            }
        });
    }

    public void run() {
        if (!this._excuting) {
            this._excuting = true;
            if (ClientCoreSDK.DEBUG) {
                Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u63a5\u6536\u65b9\u3011++++++++++ START \u6682\u5b58\u5904\u7406\u7ebf\u7a0b\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u5f53\u524d\u957f\u5ea6" + this.recievedMessages.size() + ".");
            }
            for (String key : this.recievedMessages.keySet()) {
                Long recievedTime = this.recievedMessages.get(key);
                long delta = System.currentTimeMillis() - (recievedTime == null ? 0L : recievedTime);
                if (delta < 600000L) continue;
                if (ClientCoreSDK.DEBUG) {
                    Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u63a5\u6536\u65b9\u3011\u6307\u7eb9\u4e3a" + key + "\u7684\u5305\u5df2\u751f\u5b58" + delta + "ms(\u6700\u5927\u5141\u8bb8" + 600000 + "ms), \u9a6c\u4e0a\u5c06\u5220\u9664\u4e4b.");
                }
                this.recievedMessages.remove(key);
            }
        }
        if (ClientCoreSDK.DEBUG) {
            Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u63a5\u6536\u65b9\u3011++++++++++ END \u6682\u5b58\u5904\u7406\u7ebf\u7a0b\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u5f53\u524d\u957f\u5ea6" + this.recievedMessages.size() + ".");
        }
        this._excuting = false;
    }

    public void startup(boolean immediately) {
        this.stop();
        if (this.recievedMessages != null && this.recievedMessages.size() > 0) {
            for (String key : this.recievedMessages.keySet()) {
                this.putImpl(key);
            }
        }
        if (immediately) {
            this.timer.setInitialDelay(0);
        } else {
            this.timer.setInitialDelay(300000);
        }
        this.timer.start();
        this.running = true;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void addRecieved(Protocal p) {
        if (p != null && p.isQoS()) {
            this.addRecieved(p.getFp());
        }
    }

    public void addRecieved(String fingerPrintOfProtocal) {
        if (fingerPrintOfProtocal == null) {
            Log.w(TAG, "\u3010IMCORE-UDP\u3011\u65e0\u6548\u7684 fingerPrintOfProtocal==null!");
            return;
        }
        if (this.recievedMessages.containsKey(fingerPrintOfProtocal)) {
            Log.w(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u63a5\u6536\u65b9\u3011\u6307\u7eb9\u4e3a" + fingerPrintOfProtocal + "\u7684\u6d88\u606f\u5df2\u7ecf\u5b58\u5728\u4e8e\u63a5\u6536\u5217\u8868\u4e2d\uff0c\u8be5\u6d88\u606f\u91cd\u590d\u4e86\uff08\u539f\u7406\u53ef\u80fd\u662f\u5bf9\u65b9\u56e0\u672a\u6536\u5230\u5e94\u7b54\u5305\u800c\u9519\u8bef\u91cd\u4f20\u5bfc\u81f4\uff09\uff0c\u66f4\u65b0\u6536\u5230\u65f6\u95f4\u6233\u54e6.");
        }
        this.putImpl(fingerPrintOfProtocal);
    }

    private void putImpl(String fingerPrintOfProtocal) {
        if (fingerPrintOfProtocal != null) {
            this.recievedMessages.put(fingerPrintOfProtocal, System.currentTimeMillis());
        }
    }

    public boolean hasRecieved(String fingerPrintOfProtocal) {
        return this.recievedMessages.containsKey(fingerPrintOfProtocal);
    }

    public void clear() {
        this.recievedMessages.clear();
    }

    public int size() {
        return this.recievedMessages.size();
    }
}

