/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.core;

import java.net.DatagramSocket;
import java.net.InetAddress;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.conf.ConfigEntity;
import net.x52im.mobileimsdk.java.core.LocalDataReciever;
import net.x52im.mobileimsdk.java.core.LocalSocketProvider;
import net.x52im.mobileimsdk.java.core.QoS4SendDaemon;
import net.x52im.mobileimsdk.java.utils.Log;
import net.x52im.mobileimsdk.java.utils.UDPUtils;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.protocal.c.PLoginInfo;
import org.jdesktop.swingworker.SwingWorker;

public class LocalDataSender {
    private static final String TAG = LocalDataSender.class.getSimpleName();
    private static LocalDataSender instance = null;

    public static LocalDataSender getInstance() {
        if (instance == null) {
            instance = new LocalDataSender();
        }
        return instance;
    }

    private LocalDataSender() {
    }

    int sendLogin(PLoginInfo loginInfo) {
        byte[] b = ProtocalFactory.createPLoginInfo((PLoginInfo)loginInfo).toBytes();
        int code = this.send(b, b.length);
        if (code == 0) {
            ClientCoreSDK.getInstance().setCurrentLoginInfo(loginInfo);
        }
        return code;
    }

    public int sendLoginout() {
        int code = 0;
        if (ClientCoreSDK.getInstance().isLoginHasInit()) {
            byte[] b = ProtocalFactory.createPLoginoutInfo((String)ClientCoreSDK.getInstance().getCurrentLoginUserId()).toBytes();
            code = this.send(b, b.length);
        }
        ClientCoreSDK.getInstance().release();
        return code;
    }

    int sendKeepAlive() {
        byte[] b = ProtocalFactory.createPKeepAlive((String)ClientCoreSDK.getInstance().getCurrentLoginUserId()).toBytes();
        return this.send(b, b.length);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, -1);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, int typeu) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, null, typeu);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, String fingerPrint, int typeu) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, true, fingerPrint, typeu);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, boolean QoS, String fingerPrint, int typeu) {
        return this.sendCommonData(ProtocalFactory.createCommonData((String)dataContentWidthStr, (String)ClientCoreSDK.getInstance().getCurrentLoginUserId(), (String)to_user_id, (boolean)QoS, (String)fingerPrint, (int)typeu));
    }

    public int sendCommonData(Protocal p) {
        if (p != null) {
            byte[] b = p.toBytes();
            int code = this.send(b, b.length);
            if (code == 0 && p.isQoS() && !QoS4SendDaemon.getInstance().exist(p.getFp())) {
                QoS4SendDaemon.getInstance().put(p);
            }
            return code;
        }
        return 4;
    }

    private int send(byte[] fullProtocalBytes, int dataLen) {
        if (!ClientCoreSDK.getInstance().isInitialed()) {
            return 203;
        }
        DatagramSocket ds = LocalSocketProvider.getInstance().getLocalSocket();
        if (ds != null && !ds.isConnected()) {
            block5: {
                try {
                    if (ConfigEntity.serverIP != null) break block5;
                    Log.w(TAG, "\u3010IMCORE-UDP\u3011send\u6570\u636e\u6ca1\u6709\u7ee7\u7eed\uff0c\u539f\u56e0\u662fConfigEntity.server_ip==null!");
                    return 205;
                }
                catch (Exception e) {
                    Log.w(TAG, "\u3010IMCORE-UDP\u3011send\u65f6\u51fa\u9519\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), e);
                    return 202;
                }
            }
            ds.connect(InetAddress.getByName(ConfigEntity.serverIP), ConfigEntity.serverPort);
        }
        return UDPUtils.send(ds, fullProtocalBytes, dataLen) ? 0 : 3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SendCommonDataAsync
    extends SwingWorker<Integer, Object> {
        protected Protocal p = null;

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id) {
            this(dataContentWidthStr, to_user_id, null, -1);
        }

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id, int typeu) {
            this(dataContentWidthStr, to_user_id, null, typeu);
        }

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id, String fingerPrint, int typeu) {
            this(ProtocalFactory.createCommonData((String)dataContentWidthStr, (String)ClientCoreSDK.getInstance().getCurrentLoginUserId(), (String)to_user_id, (boolean)true, (String)fingerPrint, (int)typeu));
        }

        public SendCommonDataAsync(Protocal p) {
            if (p == null) {
                Log.w(TAG, "\u3010IMCORE-UDP\u3011\u65e0\u6548\u7684\u53c2\u6570p==null!");
                return;
            }
            this.p = p;
        }

        protected Integer doInBackground() {
            if (this.p != null) {
                return LocalDataSender.getInstance().sendCommonData(this.p);
            }
            return -1;
        }

        protected void done() {
            int code = -1;
            try {
                code = (Integer)this.get();
            }
            catch (Exception e) {
                Log.w(TAG, e.getMessage());
            }
            this.onPostExecute(code);
        }

        protected abstract void onPostExecute(Integer var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SendLoginDataAsync
    extends SwingWorker<Integer, Object> {
        protected PLoginInfo loginInfo = null;

        public SendLoginDataAsync(PLoginInfo loginInfo) {
            this.loginInfo = loginInfo;
            ClientCoreSDK.getInstance().init();
        }

        protected Integer doInBackground() {
            int code = LocalDataSender.getInstance().sendLogin(this.loginInfo);
            return code;
        }

        protected void done() {
            int code = -1;
            try {
                code = (Integer)this.get();
            }
            catch (Exception e) {
                Log.w(TAG, e.getMessage());
            }
            this.onPostExecute(code);
        }

        protected void onPostExecute(Integer code) {
            if (code == 0) {
                LocalDataReciever.getInstance().startup();
            } else {
                Log.d(TAG, "\u3010IMCORE-UDP\u3011\u6570\u636e\u53d1\u9001\u5931\u8d25, \u9519\u8bef\u7801\u662f\uff1a" + code + "\uff01");
            }
            this.fireAfterSendLogin(code);
        }

        protected void fireAfterSendLogin(int code) {
        }
    }
}

