/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.core;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Observable;
import java.util.Observer;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.conf.ConfigEntity;
import net.x52im.mobileimsdk.java.core.AutoReLoginDaemon;
import net.x52im.mobileimsdk.java.core.KeepAliveDaemon;
import net.x52im.mobileimsdk.java.core.LocalDataSender;
import net.x52im.mobileimsdk.java.core.LocalSocketProvider;
import net.x52im.mobileimsdk.java.core.QoS4ReciveDaemon;
import net.x52im.mobileimsdk.java.core.QoS4SendDaemon;
import net.x52im.mobileimsdk.java.utils.Log;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.protocal.s.PErrorResponse;
import net.x52im.mobileimsdk.server.protocal.s.PKickoutInfo;
import net.x52im.mobileimsdk.server.protocal.s.PLoginInfoResponse;

public class LocalDataReciever {
    private static final String TAG = LocalDataReciever.class.getSimpleName();
    private static LocalDataReciever instance = null;
    private static MessageHandler messageHandler = null;
    private Thread thread = null;

    public static LocalDataReciever getInstance() {
        if (instance == null) {
            instance = new LocalDataReciever();
            messageHandler = new MessageHandler();
        }
        return instance;
    }

    private LocalDataReciever() {
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public void startup() {
        this.stop();
        try {
            this.thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        if (ClientCoreSDK.DEBUG) {
                            Log.d(TAG, "\u3010IMCORE\u3011\u672c\u5730UDP\u7aef\u53e3\u4fa6\u542c\u4e2d\uff0c\u7aef\u53e3=" + ConfigEntity.localPort + "...");
                        }
                        LocalDataReciever.this.udpListeningImpl();
                    }
                    catch (Exception eee) {
                        Log.w(TAG, "\u3010IMCORE-UDP\u3011\u672c\u5730UDP\u76d1\u542c\u505c\u6b62\u4e86(socket\u88ab\u5173\u95ed\u4e86?)\uff1a" + eee.getMessage() + "\uff0c\u5e94\u8be5\u662f\u7528\u6237\u9000\u51fa\u767b\u9646\u6216\u7f51\u7edc\u65ad\u5f00\u4e86\u3002");
                    }
                }
            });
            this.thread.start();
        }
        catch (Exception e) {
            Log.w(TAG, "\u3010IMCORE-UDP\u3011\u672c\u5730UDPSocket\u76d1\u542c\u5f00\u542f\u65f6\u53d1\u751f\u5f02\u5e38," + e.getMessage(), e);
        }
    }

    private void udpListeningImpl() throws Exception {
        while (true) {
            byte[] data = new byte[1024];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            DatagramSocket localUDPSocket = LocalSocketProvider.getInstance().getLocalSocket();
            if (localUDPSocket == null || localUDPSocket.isClosed()) continue;
            localUDPSocket.receive(packet);
            messageHandler.handleMessage(packet);
        }
    }

    private static class MessageHandler {
        public void handleMessage(DatagramPacket p) {
            DatagramPacket packet = p;
            if (packet == null) {
                return;
            }
            try {
                Protocal pFromServer = ProtocalFactory.parse((byte[])packet.getData(), (int)packet.getLength());
                if (pFromServer.isQoS()) {
                    if (pFromServer.getType() == 50 && ProtocalFactory.parsePLoginInfoResponse((String)pFromServer.getDataContent()).getCode() != 0) {
                        if (ClientCoreSDK.DEBUG) {
                            Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010BugFIX\u3011\u8fd9\u662f\u670d\u52a1\u7aef\u7684\u767b\u9646\u8fd4\u56de\u54cd\u5e94\u5305\uff0c\u4e14\u670d\u52a1\u7aef\u5224\u5b9a\u767b\u9646\u5931\u8d25(\u5373code!=0)\uff0c\u672c\u6b21\u65e0\u9700\u53d1\u9001ACK\u5e94\u7b54\u5305\uff01");
                        }
                    } else {
                        if (QoS4ReciveDaemon.getInstance().hasRecieved(pFromServer.getFp())) {
                            if (ClientCoreSDK.DEBUG) {
                                Log.d(TAG, "\u3010IMCORE\u3011\u3010QoS\u673a\u5236\u3011" + pFromServer.getFp() + "\u5df2\u7ecf\u5b58\u5728\u4e8e\u53d1\u9001\u5217\u8868\u4e2d\uff0c\u8fd9\u662f\u91cd\u590d\u5305\uff0c\u901a\u77e5\u5e94\u7528\u5c42\u6536\u5230\u8be5\u5305\u7f57\uff01");
                            }
                            QoS4ReciveDaemon.getInstance().addRecieved(pFromServer);
                            this.sendRecievedBack(pFromServer);
                            return;
                        }
                        QoS4ReciveDaemon.getInstance().addRecieved(pFromServer);
                        this.sendRecievedBack(pFromServer);
                    }
                }
                switch (pFromServer.getType()) {
                    case 2: {
                        if (ClientCoreSDK.getInstance().getChatMessageEvent() != null) {
                            ClientCoreSDK.getInstance().getChatMessageEvent().onRecieveMessage(pFromServer.getFp(), pFromServer.getFrom(), pFromServer.getDataContent(), pFromServer.getTypeu());
                        }
                        break;
                    }
                    case 51: {
                        if (ClientCoreSDK.DEBUG) {
                            Log.p(TAG, "\u3010IMCORE-UDP\u3011\u6536\u5230\u670d\u52a1\u7aef\u56de\u8fc7\u6765\u7684Keep Alive\u5fc3\u8df3\u54cd\u5e94\u5305.");
                        }
                        KeepAliveDaemon.getInstance().updateGetKeepAliveResponseFromServerTimstamp();
                        break;
                    }
                    case 4: {
                        String theFingerPrint = pFromServer.getDataContent();
                        if (ClientCoreSDK.DEBUG) {
                            Log.i(TAG, "\u3010IMCORE\u3011\u3010QoS\u3011\u6536\u5230" + pFromServer.getFrom() + "\u53d1\u8fc7\u6765\u7684\u6307\u7eb9\u4e3a" + theFingerPrint + "\u7684\u5e94\u7b54\u5305.");
                        }
                        if (ClientCoreSDK.getInstance().getMessageQoSEvent() != null) {
                            ClientCoreSDK.getInstance().getMessageQoSEvent().messagesBeReceived(theFingerPrint);
                        }
                        QoS4SendDaemon.getInstance().remove(theFingerPrint);
                        break;
                    }
                    case 50: {
                        PLoginInfoResponse loginInfoRes = ProtocalFactory.parsePLoginInfoResponse((String)pFromServer.getDataContent());
                        if (loginInfoRes.getCode() == 0) {
                            if (!ClientCoreSDK.getInstance().isLoginHasInit()) {
                                ClientCoreSDK.getInstance().saveFirstLoginTime(loginInfoRes.getFirstLoginTime());
                            }
                            ClientCoreSDK.getInstance().setLoginHasInit(true);
                            AutoReLoginDaemon.getInstance().stop();
                            KeepAliveDaemon.getInstance().setNetworkConnectionLostObserver(new Observer(){

                                public void update(Observable observable, Object data) {
                                    LocalSocketProvider.getInstance().closeLocalSocket();
                                    QoS4ReciveDaemon.getInstance().stop();
                                    ClientCoreSDK.getInstance().setConnectedToServer(false);
                                    if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
                                        ClientCoreSDK.getInstance().getChatBaseEvent().onLinkClose(-1);
                                    }
                                    AutoReLoginDaemon.getInstance().start(true);
                                }
                            });
                            KeepAliveDaemon.getInstance().start(false);
                            QoS4SendDaemon.getInstance().startup(true);
                            QoS4ReciveDaemon.getInstance().startup(true);
                            ClientCoreSDK.getInstance().setConnectedToServer(true);
                        } else {
                            LocalDataReciever.getInstance().stop();
                            ClientCoreSDK.getInstance().setConnectedToServer(false);
                        }
                        if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
                            ClientCoreSDK.getInstance().getChatBaseEvent().onLoginResponse(loginInfoRes.getCode());
                        }
                        break;
                    }
                    case 52: {
                        PErrorResponse errorRes = ProtocalFactory.parsePErrorResponse((String)pFromServer.getDataContent());
                        if (errorRes.getErrorCode() == 301) {
                            ClientCoreSDK.getInstance().setLoginHasInit(false);
                            Log.e(TAG, "\u3010IMCORE-UDP\u3011\u6536\u5230\u670d\u52a1\u7aef\u7684\u201c\u5c1a\u672a\u767b\u9646\u201d\u7684\u9519\u8bef\u6d88\u606f\uff0c\u5fc3\u8df3\u7ebf\u7a0b\u5c06\u505c\u6b62\uff0c\u8bf7\u5e94\u7528\u5c42\u91cd\u65b0\u767b\u9646.");
                            KeepAliveDaemon.getInstance().stop();
                            AutoReLoginDaemon.getInstance().start(false);
                        }
                        if (ClientCoreSDK.getInstance().getChatMessageEvent() != null) {
                            ClientCoreSDK.getInstance().getChatMessageEvent().onErrorResponse(errorRes.getErrorCode(), errorRes.getErrorMsg());
                        }
                        break;
                    }
                    case 54: {
                        this.onKickout(pFromServer);
                        break;
                    }
                    default: {
                        Log.w(TAG, "\u3010IMCORE-UDP\u3011\u6536\u5230\u7684\u670d\u52a1\u7aef\u6d88\u606f\u7c7b\u578b\uff1a" + pFromServer.getType() + "\uff0c\u4f46\u76ee\u524d\u8be5\u7c7b\u578b\u5ba2\u6237\u7aef\u4e0d\u652f\u6301\u89e3\u6790\u548c\u5904\u7406\uff01");
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.w(TAG, "\u3010IMCORE-UDP\u3011\u5904\u7406\u6d88\u606f\u7684\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u9519\u8bef.", e);
            }
        }

        protected void onKickout(Protocal pFromServer) {
            if (ClientCoreSDK.DEBUG) {
                Log.d(TAG, "\u3010IMCORE-UDP\u3011\u6536\u5230\u670d\u52a1\u7aef\u53d1\u8fc7\u6765\u7684\u201c\u88ab\u8e22\u201d\u6307\u4ee4.");
            }
            ClientCoreSDK.getInstance().release();
            PKickoutInfo kickoutInfo = ProtocalFactory.parsePKickoutInfo((String)pFromServer.getDataContent());
            if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
                ClientCoreSDK.getInstance().getChatBaseEvent().onKickout(kickoutInfo);
            }
            if (ClientCoreSDK.getInstance().getChatBaseEvent() != null) {
                ClientCoreSDK.getInstance().getChatBaseEvent().onLinkClose(-1);
            }
        }

        private void sendRecievedBack(final Protocal pFromServer) {
            if (pFromServer.getFp() != null) {
                new LocalDataSender.SendCommonDataAsync(ProtocalFactory.createRecivedBack((String)pFromServer.getTo(), (String)pFromServer.getFrom(), (String)pFromServer.getFp(), (boolean)pFromServer.isBridge())){

                    protected void onPostExecute(Integer code) {
                        if (ClientCoreSDK.DEBUG) {
                            Log.d(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u5411" + pFromServer.getFrom() + "\u53d1\u9001" + pFromServer.getFp() + "\u5305\u7684\u5e94\u7b54\u5305\u6210\u529f,from=" + pFromServer.getTo() + "\uff01");
                        }
                    }
                }.execute();
            } else {
                Log.w(TAG, "\u3010IMCORE-UDP\u3011\u3010QoS\u3011\u6536\u5230" + pFromServer.getFrom() + "\u53d1\u8fc7\u6765\u9700\u8981QoS\u7684\u5305\uff0c\u4f46\u5b83\u7684\u6307\u7eb9\u7801\u5374\u4e3anull\uff01\u65e0\u6cd5\u53d1\u5e94\u7b54\u5305\uff01");
            }
        }
    }
}

