/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class Platform {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINDOWS_MASK = 40967;
    public static final int OS_UNIX_MASK = 136184;
    private static int operatingSystem = -1;

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 8192 : (osName.startsWith("Windows ") ? 32768 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 2048 : ("OpenVMS".equals(osName) ? 16384 : (osName.equals("Mac OS X") ? 4096 : (osName.startsWith("Darwin") ? 4096 : (osName.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : 65536)))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (Platform.getOperatingSystem() & 0xA007) != 0;
    }

    public static boolean isUnix() {
        return (Platform.getOperatingSystem() & 0x213F8) != 0;
    }

    public static boolean isLargeFrameIcons() {
        return Platform.getOperatingSystem() == 8 || Platform.getOperatingSystem() == 32;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window w;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && (w = SwingUtilities.getWindowAncestor(focusOwner)) != null) {
            return w.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Platform.getUsableScreenBounds(Platform.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration gconf) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = new Rectangle(gconf.getBounds());
        String str = System.getProperty("netbeans.screen.insets");
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ", ");
            if (st.countTokens() == 4) {
                try {
                    bounds.y = Integer.parseInt(st.nextToken());
                    bounds.x = Integer.parseInt(st.nextToken());
                    bounds.height -= bounds.y + Integer.parseInt(st.nextToken());
                    bounds.width -= bounds.x + Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException ex) {
                    Logger.getAnonymousLogger().log(Level.WARNING, null, ex);
                }
            }
            return bounds;
        }
        str = System.getProperty("netbeans.taskbar.height");
        if (str != null) {
            bounds.height -= Integer.getInteger(str, 0).intValue();
            return bounds;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(gconf);
            bounds.y += insets.top;
            bounds.x += insets.left;
            bounds.height -= insets.top + insets.bottom;
            bounds.width -= insets.left + insets.right;
        }
        catch (Exception ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, null, ex);
        }
        return bounds;
    }
}

