/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.common.util.SimpleLogger;
import java.util.Stack;

public class FormulaHelper {
    public static final String OPRAND_SYMBLE = "+-*/#";

    public static double compute(String expression) throws Exception {
        try {
            Stack<String> Opts = new Stack<String>();
            Stack<String> Values2 = new Stack<String>();
            String exp = expression + "#";
            int nCount = exp.length();
            Opts.push("#");
            String temp = "";
            String optOut = "";
            String optIn = "";
            String value1 = "";
            String value2 = "";
            String opt = "";
            String temp1 = "";
            int i = 0;
            while (i < nCount) {
                int nOut;
                opt = exp.substring(i, i + 1);
                int nTemp = 0;
                temp1 = "";
                while (i < nCount && FormulaHelper.isOperator(opt, i + nTemp + 1 >= nCount ? "" : exp.substring(i + nTemp + 1, i + nTemp + 2))) {
                    temp1 = temp1 + opt;
                    opt = exp.substring(i + ++nTemp, i + nTemp + 1);
                }
                temp = temp1.equals("") ? opt : temp1;
                if (nTemp > 0) {
                    i = i + nTemp - 1;
                }
                if ((temp = temp.trim()).equals("")) {
                    ++i;
                    continue;
                }
                if (FormulaHelper.isOperator(temp, "")) {
                    Values2.push(temp);
                    ++i;
                    continue;
                }
                optIn = Opts.pop().toString();
                int nIn = FormulaHelper.getOprandPriorityIn(optIn);
                if (nIn == (nOut = FormulaHelper.getOprandPriorityOut(temp))) {
                    ++i;
                    continue;
                }
                if (nIn > nOut) {
                    String ret = "";
                    value1 = Values2.pop().toString();
                    value2 = Values2.pop().toString();
                    ret = String.valueOf(FormulaHelper.computeValue(value2, optIn, value1));
                    Values2.push(ret);
                    continue;
                }
                if (nIn >= nOut) continue;
                Opts.push(optIn);
                Opts.push(temp);
                ++i;
            }
            double result = Double.parseDouble((String)Values2.pop());
            SimpleLogger.debug("compute result: " + result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8868\u8fbe\u5f0f" + expression + "\u683c\u5f0f\u975e\u6cd5!");
        }
    }

    private static int getOprandPriorityOut(String oprand) throws Exception {
        if (oprand.equals("+")) {
            return 1;
        }
        if (oprand.equals("-")) {
            return 2;
        }
        if (oprand.equals("*")) {
            return 5;
        }
        if (oprand.equals("/")) {
            return 6;
        }
        if (oprand.equals("#")) {
            return 0;
        }
        if (oprand.equals("(")) {
            return 100;
        }
        if (oprand.equals(")")) {
            return -100;
        }
        throw new Exception("\u8fd0\u7b97\u7b26" + oprand + "\u975e\u6cd5!");
    }

    private static int getOprandPriorityIn(String oprand) throws Exception {
        if (oprand.equals("+")) {
            return 3;
        }
        if (oprand.equals("-")) {
            return 4;
        }
        if (oprand.equals("*")) {
            return 8;
        }
        if (oprand.equals("/")) {
            return 9;
        }
        if (oprand.equals("(")) {
            return -100;
        }
        if (oprand.equals(")")) {
            return 100;
        }
        if (oprand.equals("#")) {
            return 0;
        }
        throw new Exception("\u8fd0\u7b97\u7b26" + oprand + "\u975e\u6cd5\uff01");
    }

    private static boolean isOperator(String cValue, String nextValue) {
        String notValue = FormulaHelper.getOprandSymble() + "()";
        if (!nextValue.equals("") && !nextValue.equals(" ") && cValue.equals("-") && FormulaHelper.isOperator(nextValue, "")) {
            return true;
        }
        return notValue.indexOf(cValue) == -1;
    }

    private static boolean isOperand(String str) {
        return FormulaHelper.getOprandSymble().indexOf(str) >= 0;
    }

    private static String getOprandSymble() {
        return OPRAND_SYMBLE;
    }

    public static double computeValue(String oprand1, String operator, String oprand2) throws Exception {
        double dbValue2;
        double dbValue1;
        try {
            dbValue1 = Double.valueOf(oprand1);
            dbValue2 = Double.valueOf(oprand2);
        }
        catch (Exception e) {
            throw new Exception("\u503c" + oprand1 + "\u6216" + oprand2 + "\u5728\u8fdb\u884c" + operator + "\u8fd0\u7b97\u65f6\u975e\u6cd5\uff01");
        }
        if (operator.equals("+")) {
            return dbValue1 + dbValue2;
        }
        if (operator.equals("-")) {
            return dbValue1 - dbValue2;
        }
        if (operator.equals("*")) {
            return dbValue1 * dbValue2;
        }
        if (operator.equals("/")) {
            return dbValue1 / dbValue2;
        }
        throw new Exception("\u8fd0\u7b97\u7b26" + operator + "\u975e\u6cd5\uff01");
    }

    public static String parsePlaceholderToExpression(String[] operators, String expressionWithPlaceholder) throws Exception {
        SimpleLogger.debug("before parse: " + expressionWithPlaceholder);
        String s = expressionWithPlaceholder;
        while (s.indexOf("%") != -1) {
            int index = s.indexOf("%");
            int i = index + 1;
            String number = "";
            while (i < s.length() && CommonUtils.isNumber(s.charAt(i))) {
                number = String.valueOf(number) + (s.charAt(i) + "");
                ++i;
            }
            int oNumber = Integer.parseInt(number);
            s = s.replaceFirst("%" + number, operators[oNumber]);
        }
        SimpleLogger.debug("end parse: " + s);
        return s;
    }
}

