/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.calendar;

public class ChineseCalendar {
    private static final int[] iLunarMonthDaysTable = new int[]{19168, 42352, 21096, 53856, 55632, 27304, 22176, 39632, 19176, 19168, 42200, 42192, 53840, 54600, 46416, 22176, 38608, 38320, 18872, 18864, 42160, 45656, 27216, 27968, 44456, 11104, 38256, 18808, 18800, 25776, 54432, 59984, 27976, 23248, 11104, 37744, 37600, 51560, 51536, 54432, 55888, 46416, 22176, 43736, 9680, 37584, 51544, 43344, 46248, 27808, 46416, 21928, 19872, 42416, 21176, 21168, 43344, 59728, 27296, 44368, 43856, 19296, 42352, 42352, 21088, 59696, 55632, 23208, 22176, 38608, 19176, 19152, 42192, 53864, 53840, 54568, 46400, 46752, 38608, 38320, 18864, 42168, 42160, 45656, 27216, 27968, 44448, 43872, 37744, 18808, 18800, 25776, 27216, 59984, 27432, 23232, 43872, 37736, 37600, 51552, 54440, 54432, 55888, 23208, 22176, 43736, 9680, 37584, 51544, 43344, 46240, 46416, 46416, 21928, 19360, 42416, 21176, 21168, 43312, 29864, 27296, 44368, 19880, 19296, 38256, 42208, 53856, 59696, 54576, 23200, 27472, 38608, 19176, 19152, 42192, 53848, 53840, 54560, 55968, 46496, 22224, 19160, 18864, 42168, 42160, 43600, 46376, 27936, 44448, 21936};
    private static final char[] iLunarLeapMonthTable;
    private static final char[] iSolarLunarOffsetTable;

    static {
        char[] cArray = new char[75];
        cArray[1] = 80;
        cArray[2] = 4;
        cArray[4] = 32;
        cArray[5] = 96;
        cArray[6] = 5;
        cArray[8] = 32;
        cArray[9] = 112;
        cArray[10] = 5;
        cArray[12] = 64;
        cArray[13] = 2;
        cArray[14] = 6;
        cArray[16] = 80;
        cArray[17] = 3;
        cArray[18] = 7;
        cArray[20] = 96;
        cArray[21] = 4;
        cArray[23] = 32;
        cArray[24] = 112;
        cArray[25] = 5;
        cArray[27] = 48;
        cArray[28] = 128;
        cArray[29] = 6;
        cArray[31] = 64;
        cArray[32] = 3;
        cArray[33] = 7;
        cArray[35] = 80;
        cArray[36] = 4;
        cArray[37] = 8;
        cArray[39] = 96;
        cArray[40] = 4;
        cArray[41] = 10;
        cArray[43] = 96;
        cArray[44] = 5;
        cArray[46] = 48;
        cArray[47] = 128;
        cArray[48] = 5;
        cArray[50] = 64;
        cArray[51] = 2;
        cArray[52] = 7;
        cArray[54] = 80;
        cArray[55] = 4;
        cArray[56] = 9;
        cArray[58] = 96;
        cArray[59] = 4;
        cArray[61] = 32;
        cArray[62] = 96;
        cArray[63] = 5;
        cArray[65] = 48;
        cArray[66] = 176;
        cArray[67] = 6;
        cArray[69] = 80;
        cArray[70] = 2;
        cArray[71] = 7;
        cArray[73] = 80;
        cArray[74] = 3;
        iLunarLeapMonthTable = cArray;
        iSolarLunarOffsetTable = new char[]{'1', '&', '\u001c', '.', '\"', '\u0018', '+', ' ', '\u0015', '(', '\u001d', '0', '$', '\u0019', ',', '\"', '\u0016', ')', '\u001f', '2', '&', '\u001b', '.', '#', '\u0017', '+', ' ', '\u0016', '(', '\u001d', '/', '$', '\u0019', ',', '\"', '\u0017', ')', '\u001e', '1', '&', '\u001a', '-', '#', '\u0018', '+', ' ', '\u0015', '(', '\u001c', '/', '$', '\u001a', ',', '!', '\u0017', '*', '\u001e', '0', '&', '\u001b', '-', '#', '\u0018', '+', ' ', '\u0014', '\'', '\u001d', '/', '$', '\u001a', '-', '!', '\u0016', ')', '\u001e', '0', '%', '\u001b', '.', '#', '\u0018', '+', ' ', '2', '\'', '\u001c', '/', '$', '\u001a', '-', '\"', '\u0016', '(', '\u001e', '1', '%', '\u001b', '.', '#', '\u0017', '*', '\u001f', '\u0015', '\'', '\u001c', '0', '%', '\u0019', ',', '!', '\u0017', ')', '\u001f', '2', '\'', '\u001c', '/', '#', '\u0018', '*', '\u001e', '\u0015', '(', '\u001c', '/', '$', '\u0019', '+', '!', '\u0016', ')', '\u001e', '1', '%', '\u001a', ',', '!', '\u0017', '*', '\u001f', '\u0015', '(', '\u001d', '/', '$', '\u0019', ',', ' ', '\u0016'};
    }

    public static boolean bIsSolarLeapYear(int iYear) {
        return iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0;
    }

    public static int iGetSYearMonthDays(int iYear, int iMonth) {
        if (iMonth == 1 || iMonth == 3 || iMonth == 5 || iMonth == 7 || iMonth == 8 || iMonth == 10 || iMonth == 12) {
            return 31;
        }
        if (iMonth == 4 || iMonth == 6 || iMonth == 9 || iMonth == 11) {
            return 30;
        }
        if (iMonth == 2) {
            if (ChineseCalendar.bIsSolarLeapYear(iYear)) {
                return 29;
            }
            return 28;
        }
        return 0;
    }

    public static int iGetSNewYearOffsetDays(int iYear, int iMonth, int iDay) {
        int iOffsetDays = 0;
        int i = 1;
        while (i < iMonth) {
            iOffsetDays += ChineseCalendar.iGetSYearMonthDays(iYear, i);
            ++i;
        }
        return iOffsetDays += iDay - 1;
    }

    public static int iGetLLeapMonth(int iYear) {
        char iMonth = iLunarLeapMonthTable[(iYear - 1901) / 2];
        if (iYear % 2 == 0) {
            return iMonth & 0xF;
        }
        return (iMonth & 0xF0) >> 4;
    }

    public static int iGetLMonthDays(int iYear, int iMonth) {
        int iLeapMonth = ChineseCalendar.iGetLLeapMonth(iYear);
        if (iMonth > 12 && iMonth - 12 != iLeapMonth || iMonth < 0) {
            System.out.println("Wrong month, ^_^ , i think you are want a -1, go to death!");
            return -1;
        }
        if (iMonth - 12 == iLeapMonth) {
            if ((iLunarMonthDaysTable[iYear - 1901] & 32768 >> iLeapMonth) == 0) {
                return 29;
            }
            return 30;
        }
        if (iLeapMonth > 0 && iMonth > iLeapMonth) {
            ++iMonth;
        }
        if ((iLunarMonthDaysTable[iYear - 1901] & 32768 >> iMonth - 1) == 0) {
            return 29;
        }
        return 30;
    }

    public static int iGetLYearDays(int iYear) {
        int iYearDays = 0;
        int iLeapMonth = ChineseCalendar.iGetLLeapMonth(iYear);
        int i = 1;
        while (i < 13) {
            iYearDays += ChineseCalendar.iGetLMonthDays(iYear, i);
            ++i;
        }
        if (iLeapMonth > 0) {
            iYearDays += ChineseCalendar.iGetLMonthDays(iYear, iLeapMonth + 12);
        }
        return iYearDays;
    }

    public static int iGetLNewYearOffsetDays(int iYear, int iMonth, int iDay) {
        int iOffsetDays = 0;
        int iLeapMonth = ChineseCalendar.iGetLLeapMonth(iYear);
        if (iLeapMonth > 0 && iLeapMonth == iMonth - 12) {
            iMonth = iLeapMonth;
            iOffsetDays += ChineseCalendar.iGetLMonthDays(iYear, iMonth);
        }
        int i = 1;
        while (i < iMonth) {
            iOffsetDays += ChineseCalendar.iGetLMonthDays(iYear, i);
            if (i == iLeapMonth) {
                iOffsetDays += ChineseCalendar.iGetLMonthDays(iYear, iLeapMonth + 12);
            }
            ++i;
        }
        return iOffsetDays += iDay - 1;
    }

    public static String sCalendarSolarToLundar(int iYear, int iMonth, int iDay) {
        int iLMonth;
        int iLDay;
        int iLYear;
        int iOffsetDays = ChineseCalendar.iGetSNewYearOffsetDays(iYear, iMonth, iDay);
        int iLeapMonth = ChineseCalendar.iGetLLeapMonth(iYear);
        if (iOffsetDays < iSolarLunarOffsetTable[iYear - 1901]) {
            iLYear = iYear - 1;
            iLDay = iOffsetDays = iSolarLunarOffsetTable[iYear - 1901] - iOffsetDays;
            iLMonth = 12;
            while (iOffsetDays > ChineseCalendar.iGetLMonthDays(iLYear, iLMonth)) {
                iLDay = iOffsetDays;
                iOffsetDays -= ChineseCalendar.iGetLMonthDays(iLYear, iLMonth);
                --iLMonth;
            }
            iLDay = iLDay == 0 ? 1 : ChineseCalendar.iGetLMonthDays(iLYear, iLMonth) - iOffsetDays + 1;
        } else {
            iLYear = iYear;
            iLDay = (iOffsetDays -= iSolarLunarOffsetTable[iYear - 1901]) + 1;
            iLMonth = 1;
            while (iOffsetDays >= 0) {
                iLDay = iOffsetDays + 1;
                if (iLeapMonth == iLMonth && (iOffsetDays -= ChineseCalendar.iGetLMonthDays(iLYear, iLMonth)) > 0) {
                    iLDay = iOffsetDays;
                    if ((iOffsetDays -= ChineseCalendar.iGetLMonthDays(iLYear, iLMonth + 12)) <= 0) {
                        iLMonth += 13;
                        break;
                    }
                }
                ++iLMonth;
            }
            --iLMonth;
        }
        return iLYear + "-" + (iLMonth > 9 ? "" + iLMonth : "0" + iLMonth) + "-" + (iLDay > 9 ? "" + iLDay : "0" + iLDay);
    }

    public static String sCalendarLundarToSolar(int iYear, int iMonth, int iDay) {
        int iSYear;
        int iYearDays;
        int iOffsetDays = ChineseCalendar.iGetLNewYearOffsetDays(iYear, iMonth, iDay) + iSolarLunarOffsetTable[iYear - 1901];
        int n = iYearDays = ChineseCalendar.bIsSolarLeapYear(iYear) ? 366 : 365;
        if (iOffsetDays >= iYearDays) {
            iSYear = iYear + 1;
            iOffsetDays -= iYearDays;
        } else {
            iSYear = iYear;
        }
        int iSDay = iOffsetDays + 1;
        int iSMonth = 1;
        while (iOffsetDays >= 0) {
            iSDay = iOffsetDays + 1;
            iOffsetDays -= ChineseCalendar.iGetSYearMonthDays(iSYear, iSMonth);
            ++iSMonth;
        }
        return iSYear + (--iSMonth > 9 ? String.valueOf(iSMonth) : "0" + iSMonth) + (iSDay > 9 ? String.valueOf(iSDay) : "0" + iSDay);
    }
}

