/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.android.core;

import android.util.Log;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.x52im.mobileimsdk.android.ClientCoreSDK;
import net.x52im.mobileimsdk.android.conf.ConfigEntity;
import net.x52im.mobileimsdk.android.core.LocalDataReciever;
import net.x52im.mobileimsdk.android.core.LocalSocketProvider;
import net.x52im.mobileimsdk.android.core.QoS4SendDaemon;
import net.x52im.mobileimsdk.android.utils.MBAsyncTask;
import net.x52im.mobileimsdk.android.utils.UDPUtils;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.protocal.c.PLoginInfo;

public class LocalDataSender {
    private static final String TAG = LocalDataSender.class.getSimpleName();
    private static LocalDataSender instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalDataSender getInstance() {
        if (instance != null) return instance;
        Class<LocalDataSender> clazz = LocalDataSender.class;
        synchronized (LocalDataSender.class) {
            if (instance != null) return instance;
            instance = new LocalDataSender();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LocalDataSender() {
    }

    int sendLogin(PLoginInfo loginInfo) {
        byte[] b = ProtocalFactory.createPLoginInfo((PLoginInfo)loginInfo).toBytes();
        int code = this.send(b, b.length);
        if (code == 0) {
            ClientCoreSDK.getInstance().setCurrentLoginInfo(loginInfo);
        }
        return code;
    }

    public int sendLoginout() {
        byte[] b;
        int code = 0;
        if (!ClientCoreSDK.getInstance().isLoginHasInit() || (code = this.send(b = ProtocalFactory.createPLoginoutInfo((String)ClientCoreSDK.getInstance().getCurrentLoginUserId()).toBytes(), b.length)) == 0) {
            // empty if block
        }
        ClientCoreSDK.getInstance().release();
        return code;
    }

    int sendKeepAlive() {
        byte[] b = ProtocalFactory.createPKeepAlive((String)ClientCoreSDK.getInstance().getCurrentLoginUserId()).toBytes();
        return this.send(b, b.length);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, -1);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, int typeu) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, null, typeu);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, String fingerPrint, int typeu) {
        return this.sendCommonData(dataContentWidthStr, to_user_id, true, fingerPrint, typeu);
    }

    public int sendCommonData(String dataContentWidthStr, String to_user_id, boolean QoS, String fingerPrint, int typeu) {
        return this.sendCommonData(ProtocalFactory.createCommonData((String)dataContentWidthStr, (String)ClientCoreSDK.getInstance().getCurrentLoginUserId(), (String)to_user_id, (boolean)QoS, (String)fingerPrint, (int)typeu));
    }

    public int sendCommonData(Protocal p) {
        if (p != null) {
            byte[] b = p.toBytes();
            int code = this.send(b, b.length);
            if (code == 0 && p.isQoS() && !QoS4SendDaemon.getInstance().exist(p.getFp())) {
                QoS4SendDaemon.getInstance().put(p);
            }
            return code;
        }
        return 4;
    }

    private int send(byte[] fullProtocalBytes, int dataLen) {
        if (!ClientCoreSDK.getInstance().isInitialed()) {
            return 203;
        }
        DatagramSocket ds = LocalSocketProvider.getInstance().getLocalSocket();
        if (ds != null && !ds.isConnected()) {
            try {
                if (ConfigEntity.serverIP == null) {
                    Log.w((String)TAG, (String)"\u3010IMCORE-UDP\u3011send\u6570\u636e\u6ca1\u6709\u7ee7\u7eed\uff0c\u539f\u56e0\u662fConfigEntity.server_ip==null!");
                    return 205;
                }
                ds.connect(InetAddress.getByName(ConfigEntity.serverIP), ConfigEntity.serverPort);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("\u3010IMCORE-UDP\u3011send\u65f6\u51fa\u9519\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage()), (Throwable)e);
                return 202;
            }
        }
        return UDPUtils.send(ds, fullProtocalBytes, dataLen) ? 0 : 3;
    }

    public static abstract class SendLoginDataAsync
    extends MBAsyncTask {
        protected PLoginInfo loginInfo = null;

        public SendLoginDataAsync(PLoginInfo loginInfo) {
            this.loginInfo = loginInfo;
        }

        @Override
        protected Integer doInBackground(Object ... params) {
            int code = LocalDataSender.getInstance().sendLogin(this.loginInfo);
            return code;
        }

        @Override
        protected void onPostExecute(Integer code) {
            if (code == 0) {
                LocalDataReciever.getInstance().startup();
            } else {
                Log.d((String)TAG, (String)("\u3010IMCORE-UDP\u3011\u6570\u636e\u53d1\u9001\u5931\u8d25, \u9519\u8bef\u7801\u662f\uff1a" + code + "\uff01"));
            }
            this.fireAfterSendLogin(code);
        }

        protected void fireAfterSendLogin(int code) {
        }
    }

    public static abstract class SendCommonDataAsync
    extends MBAsyncTask {
        protected Protocal p = null;

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id) {
            this(dataContentWidthStr, to_user_id, null, -1);
        }

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id, int typeu) {
            this(dataContentWidthStr, to_user_id, null, typeu);
        }

        public SendCommonDataAsync(String dataContentWidthStr, String to_user_id, String fingerPrint, int typeu) {
            this(ProtocalFactory.createCommonData((String)dataContentWidthStr, (String)ClientCoreSDK.getInstance().getCurrentLoginUserId(), (String)to_user_id, (boolean)true, (String)fingerPrint, (int)typeu));
        }

        public SendCommonDataAsync(Protocal p) {
            if (p == null) {
                Log.w((String)TAG, (String)"\u3010IMCORE-UDP\u3011\u65e0\u6548\u7684\u53c2\u6570p==null!");
                return;
            }
            this.p = p;
        }

        @Override
        protected Integer doInBackground(Object ... params) {
            if (this.p != null) {
                return LocalDataSender.getInstance().sendCommonData(this.p);
            }
            return -1;
        }

        @Override
        protected abstract void onPostExecute(Integer var1);
    }
}

