/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.android.core;

import android.os.Handler;
import android.util.Log;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicLong;
import net.x52im.mobileimsdk.android.ClientCoreSDK;
import net.x52im.mobileimsdk.android.core.LocalDataSender;
import net.x52im.mobileimsdk.android.utils.MBSimpleTimer;
import net.x52im.mobileimsdk.android.utils.MBThreadPoolExecutor;

public class KeepAliveDaemon {
    private static final String TAG = KeepAliveDaemon.class.getSimpleName();
    private static KeepAliveDaemon instance = null;
    public static int NETWORK_CONNECTION_TIME_OUT = 10000;
    public static int KEEP_ALIVE_INTERVAL = 3000;
    public static int NETWORK_CONNECTION_TIME_OUT_CHECK_INTERVAL = 2000;
    private boolean keepAliveRunning = false;
    private final AtomicLong lastGetKeepAliveResponseFromServerTimstamp = new AtomicLong(0L);
    private Observer networkConnectionLostObserver = null;
    private Handler keepAliveHandler = null;
    private Runnable keepAliveRunnable = null;
    private boolean keepAliveTaskExcuting = false;
    private boolean keepAliveWillStop = false;
    private MBSimpleTimer keepAliveTimeoutTimer = null;
    private boolean init = false;
    private Observer debugObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeepAliveDaemon getInstance() {
        if (instance != null) return instance;
        Class<KeepAliveDaemon> clazz = KeepAliveDaemon.class;
        synchronized (KeepAliveDaemon.class) {
            if (instance != null) return instance;
            instance = new KeepAliveDaemon();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private KeepAliveDaemon() {
        this.init();
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.keepAliveHandler = new Handler();
        this.keepAliveRunnable = () -> {
            if (!this.keepAliveTaskExcuting) {
                MBThreadPoolExecutor.runInBackground(() -> {
                    int code = this.doKeepAlive();
                    MBThreadPoolExecutor.runOnMainThread(() -> this.onKeepAlive(code));
                });
            }
        };
        this.keepAliveTimeoutTimer = new MBSimpleTimer(NETWORK_CONNECTION_TIME_OUT_CHECK_INTERVAL){

            @Override
            protected void doAction() {
                if (ClientCoreSDK.DEBUG) {
                    Log.i((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u5fc3\u8df3[\u8d85\u65f6\u68c0\u67e5]\u7ebf\u7a0b\u6267\u884c\u4e2d...");
                }
                KeepAliveDaemon.this.doTimeoutCheck();
            }
        };
        this.keepAliveTimeoutTimer.init();
        this.init = true;
    }

    private int doKeepAlive() {
        this.keepAliveTaskExcuting = true;
        if (ClientCoreSDK.DEBUG) {
            Log.i((String)TAG, (String)"\u3010IMCORE-UDP\u3011\u5fc3\u8df3\u5305[\u53d1\u9001]\u7ebf\u7a0b\u6267\u884c\u4e2d...");
        }
        int code = LocalDataSender.getInstance().sendKeepAlive();
        return code;
    }

    private void onKeepAlive(int code) {
        boolean isInitialedForKeepAlive;
        if (this.debugObserver != null) {
            this.debugObserver.update(null, 2);
        }
        if (isInitialedForKeepAlive = this.isInitialedForKeepAlive()) {
            this.lastGetKeepAliveResponseFromServerTimstamp.set(System.currentTimeMillis());
        }
        this.keepAliveTaskExcuting = false;
        if (!this.keepAliveWillStop) {
            this.keepAliveHandler.postDelayed(this.keepAliveRunnable, (long)KEEP_ALIVE_INTERVAL);
        }
    }

    private void doTimeoutCheck() {
        boolean isInitialedForKeepAlive = this.isInitialedForKeepAlive();
        if (!isInitialedForKeepAlive) {
            long now = System.currentTimeMillis();
            if (ClientCoreSDK.DEBUG) {
                Log.i((String)TAG, (String)(">>>> t1=" + now + ", t2=" + this.lastGetKeepAliveResponseFromServerTimstamp + " -> \u5dee\uff1a" + (now - this.lastGetKeepAliveResponseFromServerTimstamp.longValue())));
            }
            if (now - this.lastGetKeepAliveResponseFromServerTimstamp.longValue() >= (long)NETWORK_CONNECTION_TIME_OUT) {
                if (ClientCoreSDK.DEBUG) {
                    Log.w((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u5fc3\u8df3\u673a\u5236\u5df2\u5224\u5b9a\u7f51\u7edc\u65ad\u5f00\uff0c\u5c06\u8fdb\u5165\u65ad\u7f51\u901a\u77e5\u548c\u91cd\u8fde\u5904\u7406\u903b\u8f91 ...");
                }
                this.notifyConnectionLost();
                this.keepAliveWillStop = true;
            }
        }
    }

    private boolean isInitialedForKeepAlive() {
        return this.lastGetKeepAliveResponseFromServerTimstamp.longValue() == 0L;
    }

    public void notifyConnectionLost() {
        this.stop();
        if (this.networkConnectionLostObserver != null) {
            this.networkConnectionLostObserver.update(null, null);
        }
    }

    public void stop() {
        this.keepAliveTimeoutTimer.stop();
        this.keepAliveHandler.removeCallbacks(this.keepAliveRunnable);
        this.keepAliveRunning = false;
        this.keepAliveWillStop = false;
        this.lastGetKeepAliveResponseFromServerTimstamp.set(0L);
        if (this.debugObserver != null) {
            this.debugObserver.update(null, 0);
        }
    }

    public void start(boolean immediately) {
        this.stop();
        this.keepAliveHandler.postDelayed(this.keepAliveRunnable, immediately ? 0L : (long)KEEP_ALIVE_INTERVAL);
        this.keepAliveRunning = true;
        this.keepAliveWillStop = false;
        this.keepAliveTimeoutTimer.start(immediately);
        if (this.debugObserver != null) {
            this.debugObserver.update(null, 1);
        }
    }

    public boolean isKeepAliveRunning() {
        return this.keepAliveRunning;
    }

    public boolean isInit() {
        return this.init;
    }

    public void updateGetKeepAliveResponseFromServerTimstamp() {
        this.lastGetKeepAliveResponseFromServerTimstamp.set(System.currentTimeMillis());
    }

    public void setNetworkConnectionLostObserver(Observer networkConnectionLostObserver) {
        this.networkConnectionLostObserver = networkConnectionLostObserver;
    }

    public Observer getDebugObserver() {
        return this.debugObserver;
    }

    public void setDebugObserver(Observer debugObserver) {
        this.debugObserver = debugObserver;
    }
}

