/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

public class StringHelper {
    public static boolean isNaN(String original) {
        char c;
        int nDigits = 0;
        boolean decSeen = false;
        int i = 0;
        int l = original.length();
        block5: while (i < l) {
            c = original.charAt(i);
            switch (c) {
                default: {
                    break block5;
                }
                case '+': 
                case '-': {
                    if (i <= 0) break;
                    return true;
                }
                case '.': {
                    if (decSeen) {
                        return true;
                    }
                    decSeen = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++nDigits;
                }
            }
            ++i;
        }
        if (nDigits == 0) {
            return true;
        }
        if (i < l - 1 && (original.charAt(i) == 'e' || original.charAt(i) == 'E')) {
            if ((c = original.charAt(++i)) == '-' || c == '+') {
                ++i;
            }
            int expAt = i;
            do {
                if ((c = original.charAt(i++)) >= '0' && c <= '9') continue;
                --i;
                break;
            } while (i < l);
            if (i == expAt) {
                return true;
            }
        }
        return i < l && (i != l - 1 || original.charAt(i) != 'f' && original.charAt(i) != 'F' && original.charAt(i) != 'd' && original.charAt(i) != 'D');
    }

    public static int compareNum(String a, String b) {
        if (a.length() == 0) {
            return b.length() <= 0 ? 0 : -1;
        }
        if (b.length() == 0) {
            return 1;
        }
        int sign = a.charAt(0) != '-' ? 1 : -1;
        if (sign == -1 ^ b.charAt(0) == '-') {
            return sign;
        }
        int[] exponentAndDigitsA = new int[2];
        int[] exponentAndDigitsB = new int[2];
        char[] numberA = StringHelper.scientificNumber(a, exponentAndDigitsA);
        char[] numberB = StringHelper.scientificNumber(b, exponentAndDigitsB);
        int exponentA = exponentAndDigitsA[0];
        int exponentB = exponentAndDigitsB[0];
        return sign * (exponentA == exponentB ? StringHelper.compare(numberA, exponentAndDigitsA[1], numberB, exponentAndDigitsB[1]) : (exponentA <= exponentB ? -1 : 1));
    }

    public static char[] scientificNumber(String in, int[] exponentAndDigits) {
        char[] digits = new char[in.length()];
        int nDigits = 0;
        int decPt = -1;
        int i = 0;
        int l = in.length();
        boolean signSeen = false;
        int nLeadZero = 0;
        int nTrailZero = 0;
        int decExp = 0;
        block10: while (i < l) {
            char c = in.charAt(i);
            switch (c) {
                default: {
                    break block10;
                }
                case '+': 
                case '-': {
                    if (i > 0) {
                        throw new NumberFormatException(in);
                    }
                    signSeen = true;
                    break;
                }
                case '0': {
                    if (nDigits == 0) {
                        ++nLeadZero;
                        break;
                    }
                    ++nTrailZero;
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    while (nTrailZero > 0) {
                        digits[nDigits++] = 48;
                        --nTrailZero;
                    }
                    digits[nDigits++] = c;
                    break;
                }
                case '.': {
                    if (decPt > -1) {
                        throw new NumberFormatException("multiple points");
                    }
                    decPt = signSeen ? i - 1 : i;
                }
            }
            ++i;
        }
        if (nDigits == 0 && nLeadZero > 0) {
            digits[nDigits++] = 48;
            decExp = Integer.MIN_VALUE;
        } else {
            decExp = (decPt <= -1 ? nDigits + nTrailZero : decPt - nLeadZero) - 1;
        }
        if (i < l - 1 && (in.charAt(i) == 'e' || in.charAt(i) == 'E')) {
            int expSign = 1;
            int expVal = 0;
            char c = in.charAt(++i);
            switch (c) {
                case '-': {
                    expSign = -1;
                }
                case '+': {
                    ++i;
                }
            }
            int expAt = i;
            boolean expOverflow = false;
            do {
                if ((c = in.charAt(i++)) >= '0' && c <= '9') {
                    if ((expVal = expVal * 10 + (c - 48)) >= 0) continue;
                    expOverflow = true;
                    break;
                }
                --i;
                break;
            } while (i < l);
            if (i == expAt) {
                throw new NumberFormatException(in);
            }
            int expLimit = Integer.MAX_VALUE - nDigits - nTrailZero;
            decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
        }
        if (i < l && (i != l - 1 || in.charAt(i) != 'f' && in.charAt(i) != 'F' && in.charAt(i) != 'd' && in.charAt(i) != 'D')) {
            throw new NumberFormatException(in);
        }
        exponentAndDigits[0] = decExp;
        exponentAndDigits[1] = nDigits;
        return digits;
    }

    public static int compare(char[] a, int a_digits, char[] b, int b_digits) {
        int end = Math.min(a_digits, b_digits);
        int i = 0;
        while (i < end) {
            char c1 = a[i];
            char c2 = b[i];
            if (c1 != c2) {
                return c1 - c2;
            }
            ++i;
        }
        return a_digits == b_digits ? 0 : (a_digits <= b_digits ? -1 : 1);
    }
}

