/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

public class RMBHelper {
    private static final String[] NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] IUNIT = new String[]{"\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] DUNIT = new String[]{"\u89d2", "\u5206", "\u5398"};

    public static String toRMB(String numberStr) {
        String decimalStr;
        String integerStr;
        if ((numberStr = numberStr.replaceAll(",", "")).indexOf(".") > 0) {
            integerStr = numberStr.substring(0, numberStr.indexOf("."));
            decimalStr = numberStr.substring(numberStr.indexOf(".") + 1);
        } else if (numberStr.indexOf(".") == 0) {
            integerStr = "";
            decimalStr = numberStr.substring(1);
        } else {
            integerStr = numberStr;
            decimalStr = "";
        }
        if (!integerStr.equals("") && (integerStr = Long.toString(Long.parseLong(integerStr))).equals("0")) {
            integerStr = "";
        }
        if (integerStr.length() > IUNIT.length) {
            System.out.println(String.valueOf(numberStr) + ":\u8d85\u51fa\u5904\u7406\u80fd\u529b");
            return numberStr;
        }
        int[] integers = RMBHelper.toArray(integerStr);
        boolean isMust5 = RMBHelper.isMust5(integerStr);
        int[] decimals = RMBHelper.toArray(decimalStr);
        return String.valueOf(RMBHelper.getChineseInteger(integers, isMust5)) + RMBHelper.getChineseDecimal(decimals);
    }

    private static int[] toArray(String number) {
        int[] array = new int[number.length()];
        int i = 0;
        while (i < number.length()) {
            array[i] = Integer.parseInt(number.substring(i, i + 1));
            ++i;
        }
        return array;
    }

    private static String getChineseInteger(int[] integers, boolean isMust5) {
        StringBuffer chineseInteger = new StringBuffer("");
        int length = integers.length;
        int i = 0;
        while (i < length) {
            String key = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    key = IUNIT[4];
                } else if (length - i == 9) {
                    key = IUNIT[8];
                } else if (length - i == 5 && isMust5) {
                    key = IUNIT[4];
                } else if (length - i == 1) {
                    key = IUNIT[0];
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    key = String.valueOf(key) + NUMBERS[0];
                }
            }
            chineseInteger.append(integers[i] == 0 ? key : String.valueOf(NUMBERS[integers[i]]) + IUNIT[length - i - 1]);
            ++i;
        }
        return chineseInteger.toString();
    }

    private static String getChineseDecimal(int[] decimals) {
        StringBuffer chineseDecimal = new StringBuffer("");
        int i = 0;
        while (i < decimals.length) {
            if (i == 3) break;
            chineseDecimal.append(decimals[i] == 0 ? "" : String.valueOf(NUMBERS[decimals[i]]) + DUNIT[i]);
            ++i;
        }
        return chineseDecimal.toString();
    }

    private static boolean isMust5(String integerStr) {
        int length = integerStr.length();
        if (length > 4) {
            String subInteger = "";
            subInteger = length > 8 ? integerStr.substring(length - 8, length - 4) : integerStr.substring(0, length - 4);
            return Integer.parseInt(subInteger) > 0;
        }
        return false;
    }
}

