/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.file;

import com.eva.epc.common.file.FileHelper;
import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class EFileFilter
extends FileFilter {
    private Vector<String> filters = new Vector();
    private String description;

    public EFileFilter() {
    }

    public EFileFilter(String extension) {
        this(extension, null);
    }

    public EFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addFileExtName(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public EFileFilter(String[] filters) {
        this(filters, null);
    }

    public EFileFilter(String[] filters, String description) {
        this();
        int i = 0;
        while (i < filters.length) {
            this.addFileExtName(filters[i]);
            ++i;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileHelper.getFileExName(f);
            if (extension != null && this.filters.contains(FileHelper.getFileExName(f))) {
                return true;
            }
        }
        return false;
    }

    public void addFileExtName(String fileExtName) {
        this.filters.add(fileExtName.toLowerCase());
        this.description = null;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "(";
            int i = 0;
            while (i < this.filters.size()) {
                this.description = String.valueOf(this.description) + this.filters.get(i);
                if (i != this.filters.size() - 1) {
                    this.description = String.valueOf(this.description) + ",";
                }
                ++i;
            }
            this.description = ")";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

