# List Map

In many programming languages, map is the name of a higher-order function that
applies a given function to each element of a collection, e.g. a list or set,
returning the results in a collection of the same type. It is often called
apply-to-all when considered in functional form.

The concept of a map is not limited to lists: it works for sequential
containers, tree-like containers, or even abstract containers
such as futures and promises.

Other names

- Transform (C++)
- Collect (Ruby, Groovy)
- Select (C#)

## Write the List Map Algorithm

Write a function, `list-map`, that takes a `function` and a `list` as arguments,
and returns the list of the results of applying the `function` to each element
of the `list`.

- Function name: `list-map`
- Two function arguments: `function`, `list`

## Function Signature

```racket
check function types...
```

## References

- [Higher-Order Function Map at Wikipedia][0]

[0]: https://en.wikipedia.org/wiki/Map_(higher-order_function)
