# Project Euler 002 - Even Fibonacci Numbers

Each new term in the Fibonacci sequence is generated by adding the previous
two terms. By starting with 0 and 1, the first 10 terms will be:

```text
0, 1, 1, 2, 3, 5, 8, 13, 21, 34, ...
```

By considering the terms in the Fibonacci sequence whose values do not exceed
`n`, find the sum of the even-valued terms.

The function signature is

```python
def fibo_even_sum(limit: int) -> int
```

## Optimizations

Trial division isn't necessary. There are ways to only compute even fibonacci
numbers, including:

- Every third number in the sequence is even
- You can calculate only even members with `next fibo = 4 * next fibo + current fibo`

## Resources

- [Project Euler Problem 002][1]
- [Project Euler Problem 002 at freeCodeCamp][2]

[1]: https://projecteuler.net/problem=2
[2]: https://www.freecodecamp.org/learn/coding-interview-prep/project-euler/problem-2-even-fibonacci-numbers
