/*
 * Copyright 2015 Priyesh Patel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.chromium.fontinstaller;

import java.io.File;
import java.net.URL;

import static org.junit.Assert.fail;

public class TestUtils {

    public static File getFileResource(String fileName) {
        final URL url = TestUtils.class.getResource("/" + fileName);
        if (url == null) fail("Could not find file: /app/src/test/resources/" + fileName);
        return new File(url.getFile());
    }

}
