/*
 * Copyright 2015 Priyesh Patel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.chromium.fontinstaller.ui.settings;

import android.content.Intent;
import android.os.Bundle;

import com.chromium.fontinstaller.R;
import com.chromium.fontinstaller.ui.common.BaseActivity;

public class SettingsActivity extends BaseActivity {

  private SettingsFragment mSettingsFragment;

  @Override public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.activity_settings);
    showToolbarBackButton();
    setToolbarTitle(getString(R.string.settings_title));

    mSettingsFragment = new SettingsFragment();

    getFragmentManager().beginTransaction()
        .add(R.id.container, mSettingsFragment)
        .commit();
  }

  @Override protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (mSettingsFragment.getBillingHelper() == null) return;

    if (!mSettingsFragment.getBillingHelper().handleActivityResult(requestCode, resultCode, data)) {
      super.onActivityResult(requestCode, resultCode, data);
    }
  }
}
