/*
 * Copyright 2015 Priyesh Patel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.chromium.fontinstaller;

import com.chromium.fontinstaller.core.BackupManager;
import com.chromium.fontinstaller.core.FontsterPreferences;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

@Module
public class FontsterModule {

  private final FontsterApp mApplication;

  public FontsterModule(FontsterApp application) {
    mApplication = application;
  }

  @Provides @Singleton public FontsterApp providesApplication() {
    return mApplication;
  }

  @Provides @Singleton public FontsterPreferences providesPreferences() {
    return new FontsterPreferences(mApplication.getApplicationContext());
  }

  @Provides @Singleton public BackupManager providesBackupManager() {
    return new BackupManager();
  }

}