import {Link} from "react-router-dom";
import * as C from "./styles";


type Props = {
    title: string;
    description: string;
    icon: string;
    path: string;
    active: boolean;
    allowed: boolean;
};

export const SidebarItem = ({
                                title,
                                description,
                                icon,
                                path,
                                active,
                                allowed,
                            }: Props) => {
    return (
        <C.Container>
            <Link className={allowed ? "" : "isDisabled"} to={path}>
                <C.Info>
                    <C.Title>{title}</C.Title>
                    <C.Description>{description}</C.Description>
                </C.Info>
                <C.IconArea active={active}>
                    {icon === "profile" && (
                        <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                             xmlnsXlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                             fill="white" width={24} height={24}
                             enableBackground={"new 0 0 512 512"} xmlSpace={"preserve"}
                             viewBox="0 0 512 512">
                            <g>
                                <g>
                                    <path d="M480,309.333c0-15.125-31.168-70.912-46.72-97.813c1.451-7.68,4.053-25.237,4.053-51.52c0-45.547-60.288-160-202.667-160
                        C94.869,0,32,106.048,32,181.333c0,53.248,31.445,107.819,56.725,151.616c14.72,25.515,28.608,49.621,28.608,61.717
                        c0,27.157-44.16,80.981-61.184,99.435c-2.859,3.115-3.627,7.616-1.92,11.499c1.707,3.904,5.525,6.4,9.771,6.4h234.667
                        c5.888,0,10.368-3.115,10.368-9.003c3.776-7.616,41.664-28.075,76.672-33.813c26.283-4.288,62.272-10.197,62.272-42.517
                        c0-14.059-4.864-21.312-8.085-26.112c-2.155-3.221-2.581-4.011-3.904-5.973c5.909,0.832,11.179-3.413,11.904-9.259
                        c0.277-2.261-0.171-4.459-1.173-6.336l8.789-8.789c2.859-2.859,3.861-7.083,2.581-10.923l-7.125-21.376
                        C463.253,333.675,480,324.971,480,309.333z"/>
                                </g>
                            </g>
                        </svg>
                    )}
                    {icon === "book" && <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                                             xmlnsXlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                             viewBox="0 0 458.32 458.32" fill="white" width={24} height={24}
                                             enableBackground="new 0 0 458.32 458.32;" xmlSpace="preserve">
                        <g>
                            <g>
                                <path d="M452.611,24.82c-3.605-2.844-8.314-3.877-12.781-2.813L229.16,72.4L18.49,22.008c-4.466-1.065-9.176-0.032-12.781,2.813
                        C2.104,27.666,0,32.005,0,36.597v333.899c0,6.94,4.761,12.974,11.511,14.589c2.241,0.536,213.117,50.985,214.402,51.27
                        c1.589,0.353,3.276,0.368,3.246,0.368h0.001c1.126,0,2.555-0.188,3.489-0.411l214.161-51.227c6.75-1.615,11.51-7.648,11.51-14.589
                        V36.597C458.32,32.005,456.216,27.665,452.611,24.82z M212.161,318.549c-1.927,8.056-10.019,13.025-18.078,11.1L43.098,293.533
                        c-8.057-1.928-13.026-10.021-11.099-18.078s10.02-13.023,18.078-11.1l150.985,36.115
                        C209.119,302.398,214.088,310.492,212.161,318.549z M212.161,253.049c-1.927,8.056-10.019,13.025-18.078,11.1L43.098,228.033
                        c-8.057-1.928-13.026-10.021-11.099-18.078s10.02-13.023,18.078-11.1l150.985,36.115
                        C209.119,236.898,214.088,244.992,212.161,253.049z M212.161,187.549c-1.927,8.056-10.019,13.025-18.078,11.1L43.098,162.533
                        c-8.057-1.928-13.026-10.021-11.099-18.078s10.02-13.023,18.078-11.1l150.985,36.115
                        C209.119,171.398,214.088,179.492,212.161,187.549z M416.062,293.533l-150.985,36.115c-8.058,1.926-16.151-3.042-18.078-11.1
                        c-1.927-8.057,3.042-16.15,11.099-18.078l150.985-36.115c8.059-1.924,16.151,3.042,18.078,11.1
                        C429.088,283.512,424.119,291.605,416.062,293.533z M416.062,228.033l-150.985,36.115c-8.058,1.926-16.151-3.042-18.078-11.1
                        c-1.927-8.057,3.042-16.15,11.099-18.078l150.985-36.115c8.059-1.925,16.151,3.042,18.078,11.1
                        C429.088,218.012,424.119,226.105,416.062,228.033z M416.062,162.533l-150.985,36.115c-8.058,1.926-16.151-3.042-18.078-11.1
                        c-1.927-8.057,3.042-16.15,11.099-18.078l150.985-36.115c8.059-1.926,16.151,3.042,18.078,11.1
                        C429.088,152.512,424.119,160.605,416.062,162.533z"/>
                            </g>
                        </g>

                    </svg>
                    }
                    {icon === "mail" &&
                        <svg fill="white" width={24} height={24} version="1.1" xmlns="http://www.w3.org/2000/svg"
                             viewBox="0 0 512 512" xmlnsXlink="http://www.w3.org/1999/xlink"
                             enableBackground="new 0 0 512 512">
                            <g>
                                <g>
                                    <path
                                        d="m194.8,286.5l46.8,51.6c7.8,8.5 22.6,8.5 30.4,0l46.8-51.6 119.8,128.7h-363.6l119.8-128.7zm-27.5-30.3l-115,123.5v-250.4l115,126.9zm89.5,38l-178.9-197.4h357.7l-178.8,197.4zm204.3-164.9v250.4l-115-123.5 115-126.9zm19.4-73.3h-449c-11.3,0-20.5,9.1-20.5,20.4v359.2c0,11.3 9.2,20.4 20.5,20.4h448.9c11.3,0 20.5-9.1 20.5-20.4v-359.2c0.1-11.3-9.1-20.4-20.4-20.4z"/>
                                </g>
                            </g>
                        </svg>


                    }
                    {icon === "team" &&
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                             xmlnsXlink="http://www.w3.org/1999/xlink" enableBackground="new 0 0 512 512"
                             fill="white" width={24} height={24}
                        >
                            <g>
                                <g>
                                    <path
                                        d="m256,127.8c19.8,0 35.4-16.7 35.4-35.4 0-19.8-15.6-35.4-35.4-35.4s-35.4,15.6-35.4,35.4c2.84217e-14,19.7 15.6,35.4 35.4,35.4zm0-52.2c9.4,0 15.6,7.3 15.6,15.6 0,8.3-7.3,15.6-15.6,15.6s-15.6-6.3-15.6-15.6c0-8.3 6.2-15.6 15.6-15.6z"/>
                                    <path
                                        d="m112.1,325.9c-19.8,0-35.4,15.6-35.4,35.4s15.6,35.4 35.4,35.4c18.8,0 35.4-15.6 35.4-35.4s-15.6-35.4-35.4-35.4zm0,50c-8.3,0-15.6-7.3-15.6-15.6s6.3-15.6 15.6-15.6c8.3,0 15.6,7.3 15.6,15.6s-6.2,15.6-15.6,15.6z"/>
                                    <path
                                        d="m399.9,289.4c-33,0-62,15.4-80.4,39.5l-54.1-49.3v-57.3c51-4.8 91.7-48.6 91.7-100.7 0-56.3-44.8-101.1-101.1-101.1s-101.1,45.8-101.1,101c0,53.1 40.8,96 91.7,100.7v56.7l-54.3,49.6c-18.4-23.9-47.4-39.2-80.2-39.2-56.3,0.1-101.1,44.9-101.1,101.2s45.9,101.1 101.1,101.1 101.1-44.8 101.1-101.1c0-16.1-3.7-31.3-10.2-44.7l52.6-48.4 53.3,48.6c-6.5,13.4-10.1,28.5-10.1,44.5 0,56.3 45.9,101.1 101.1,101.1 56.3,0 101.1-44.8 101.1-101.1s-44.8-101.1-101.1-101.1zm-333.3,168.4c5-15.8 19.3-26.7 36.2-26.7h18.8c16.8,0 31.1,10.9 36.2,26.7-13,8.8-28.7,14-45.5,14-17,0-32.7-5.2-45.7-14zm106.6-13.7c-9.9-18.8-29.5-31.8-51.6-31.8h-18.8c-23,0-42.7,12.3-52.1,31.2-12.3-14.3-19.8-32.8-19.8-53.1 0-44.8 36.5-81.3 81.3-81.3 43.8,0 81.3,36.5 81.3,81.3-0.1,20.6-7.7,39.4-20.3,53.7zm82.8-241.3c-16.9,0-32.5-5.2-45.5-14 5-15.8 19.3-26.7 36.2-26.7h18.8c16.8,0 31.1,10.9 36.2,26.7-13.2,8.9-28.8,14-45.7,14zm-81.3-81.3c0-44.8 36.5-81.3 81.3-81.3s81.3,36.5 81.3,81.3c0,20.5-7.7,39.3-20.3,53.6-9.9-18.8-29.5-31.8-51.6-31.8h-18.8c-23,0-42.7,12.3-52.1,31.2-12.3-14.1-19.8-32.7-19.8-53zm179.6,336.3c5-15.8 19.3-26.7 36.2-26.7h18.8c16.8,0 31.1,10.9 36.2,26.7-13,8.8-28.7,14-45.5,14s-32.7-5.2-45.7-14zm106.6-13.7c-9.9-18.8-29.5-31.8-51.6-31.8h-18.8c-23,0-42.7,12.3-52.1,31.2-12.3-14.3-19.8-32.8-19.8-53.1 0-44.8 36.5-81.3 81.3-81.3s81.3,36.5 81.3,81.3c5.68434e-14,20.6-7.7,39.4-20.3,53.7z"/>
                                    <path
                                        d="m399.9,325.9c-19.8,0-35.4,15.6-35.4,35.4s15.6,35.4 35.4,35.4 35.4-15.6 35.4-35.4-15.6-35.4-35.4-35.4zm0,50c-8.3,0-15.6-7.3-15.6-15.6s6.3-15.6 15.6-15.6 15.6,7.3 15.6,15.6-6.2,15.6-15.6,15.6z"/>
                                </g>
                            </g>
                        </svg>
                    }
                    {icon === "check" && (
                        <svg fill="white" width={24} height={24} xmlns="http://www.w3.org/2000/svg"
                             viewBox="0 0 512 512">
                            <path
                                d="M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM371.8 211.8C382.7 200.9 382.7 183.1 371.8 172.2C360.9 161.3 343.1 161.3 332.2 172.2L224 280.4L179.8 236.2C168.9 225.3 151.1 225.3 140.2 236.2C129.3 247.1 129.3 264.9 140.2 275.8L204.2 339.8C215.1 350.7 232.9 350.7 243.8 339.8L371.8 211.8z"/>
                        </svg>
                    )}
                </C.IconArea>
                <C.Point active={active}></C.Point>
            </Link>
        </C.Container>
    )
        ;
};
