# -*- coding: utf-8 -*-
"""UniqueHangman(nd).ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1h1K8s_6X1FkTJot9fshgWSD0PT6T3RH5

### Hangman game

Welcome to the Unique Tech-themed Hangman Game! I invite you to crack the words 🙌

This notebook hosts a fun and engaging Hangman game implemented in Python. Unlike other versions, this game comes with a tech twist, featuring words from the tech world. Get ready to test your vocabulary and problem-solving skills!

This game will provide feedback on your guesses and display the progress.

*Enjoy the Game! Dive into the code and enjoy playing the Hangman game. It’s a great way to have fun while practicing your Python skills!*
"""



"""### About the Game

*   Word List: The game randomly selects words related to technology and coding.
*   Objective: Guess the tech-themed word before the hangman is fully drawn.
*   Tries: You have 7 tries to guess the word correctly.
*   **Debug Mode**:
    
    **Enable** Debug Mode: Set the **DEBUG_MODE flag** to **True** to see the chosen word for each game.
    
    **Disable** Debug Mode: Set the **DEBUG_MODE flag** to **False** to play the game without seeing the chosen word.

Follow the prompts to guess letters.

### Unique Features

1. Carefully curated words reflecting tech and coding themes. (# Option too "Hash" , deubug and play against the library for enthusiasts)
2. Play directly within the notebook for a seamless, interactive experience.
3. Custom ASCII art for hangman stages to add visual flair.
4. Thoughtful messages to guide the player through their guesses.
5. Designed to work seamlessly in Google Colab for easy access and execution.
6. Easy, medium, and hard difficulty levels to match player skill levels.
7. Option to replay the game, enhancing engagement and enjoyment.
8. Utilizes the Faker library to ensure words are randomly selected each game, providing a unique experience every time.
9. Robust input validation to handle digits, upper or lower case letters, and repeated guesses without losing chances.
10. Debugging feature for programmers to easily identify the chosen word, facilitating smoother game development and testing.
11. Helps improve vocabulary and familiarity with tech terms in a fun and interactive way.
12. I would like your comments, suggestions and how to improve it as well :D
"""

# To support randomness
!pip install faker

# Main Code
import random
import re
from faker import Faker

fake = Faker()

# Set this flag to True to enable debug mode, False to disable it
DEBUG_MODE = False

# Function to get a unique tech-themed word or phrase based on difficulty
def get_custom_word(difficulty):
    easy_words = ['DATA', 'CODE', 'DEBUG']
    medium_words = ['DATA PIPELINE', 'CLOUD COMPUTING', 'SQL DATABASE']
    hard_words = ['COMPUTATIONAL THINKING', 'MACHINE LEARNING MODEL', 'NEURAL NETWORK ARCHITECTURE']

    if difficulty == 'easy':
        chosen_word = random.choice(easy_words).upper()
    elif difficulty == 'medium':
        chosen_word = random.choice(medium_words).upper()
    elif difficulty == 'hard':
        chosen_word = random.choice(hard_words).upper()
    else:
        # Handle invalid difficulty input
        print("Invalid difficulty level. Please choose from 'easy', 'medium', or 'hard'.")
        return None

    if DEBUG_MODE:
        print(f"Debug: Chosen word is '{chosen_word}'")  # Debug line for the programmer
    return chosen_word

# Function to display hangman stages
def display_hangman(tries):
    stages = [
        """
        7:
           ------
           |    |
           |    O
           |   \|/
           |    |
           |   / \
          ---
        """,
        """
        6:
           ------
           |    |
           |    O
           |   \|/
           |    |
           |   /
          ---
        """,
        """
        5:
           ------
           |    |
           |    O
           |   \|/
           |    |
           |
          ---
        """,
        """
        4:
           ------
           |    |
           |    O
           |   \|/
           |
           |
          ---
        """,
        """
        3:
           ------
           |    |
           |    O
           |   \|
           |
           |
          ---
        """,
        """
        2:
           ------
           |    |
           |    O
           |    |
           |
           |
          ---
        """,
        """
        1:
           ------
           |    |
           |    O
           |
           |
           |
          ---
        """,
        """
        0:
           ------
           |    |
           |
           |
           |
           |
          ---
        """
    ]
    return stages[tries]

# Function to validate user input
def is_valid_input(user_input):
    return len(user_input) == 1 and user_input.isalpha()

# Function to play the unique hangman game
def play_unique_hangman():
    print("Welcome to the Unique Hangman Game!")
    difficulty = input("Choose your difficulty level: easy, medium, hard\n").lower()
    word = get_custom_word(difficulty)

    while word is None:
        difficulty = input("Please enter a valid difficulty level: easy, medium, hard\n").lower()
        word = get_custom_word(difficulty)

    word_letters = set(word) - set(" ")
    guessed_letters = set()
    tries = 7
    hidden_word = " ".join("_" if letter != " " else " " for letter in word)
    print(f"Guess the word before the hangman is fully drawn. You have {tries} tries.")
    print("Hint: All words are tech-themed!")

    while tries > 0 and word_letters:
        print(display_hangman(tries))
        print("Guessed letters:", " ".join(guessed_letters))
        print(f"Word: {hidden_word}")
        guess = input("Guess a letter or the whole word: ").upper()

        if guess == word:
            print("Congratulations! You guessed the word correctly!")
            break

        if not is_valid_input(guess):
            print("Invalid input! Please guess a single letter.")
            continue

        if guess in guessed_letters:
            print("You already guessed that letter!")
        elif guess in word_letters:
            guessed_letters.add(guess)
            word_letters.remove(guess)
            hidden_word = " ".join([letter if letter in guessed_letters or letter == " " else "_" for letter in word])
        else:
            guessed_letters.add(guess)
            tries -= 1
            print(f"Wrong! {tries} tries left.")

    if word_letters:
        print(display_hangman(tries))
        print(f"You lost! The word was '{word}'.")
    else:
        print("Congratulations! You guessed the word:", word)

    # Ask the user if they want to play again
    play_again = input("Do you want to play again? (yes/no): ").lower()
    if play_again in ['yes', 'y']:
        play_unique_hangman()

# Run the game
play_unique_hangman()