# Why should we follow this guidelines
> * Following these guidelines helps to communicate that you respect the time of the developers managing and developing this open source project. 
> * In return, they should reciprocate that respect in addressing your issue, assessing changes, and helping you finalize your pull requests.

## Ground Rules
> * Ensure cross-platform compatibility for every change that's accepted. Windows, Mac, Ubuntu Linux.
> * Keep feature versions as small as possible, preferably one new feature per version.
> * Make sure all tests pass and CI/CD pipelines pass.

## What you can do in this repo
> * Doc translate, renew, improving,etc.
> * Feature requests or writing new feature etc.
> * Submitting the bug reports, bug fix etc.
> * Sharing this repo like blog or stackoverflow even Facebook and Twitter .

## Getting started
> * Create you own fork repo.
> * Edit code on you own repo.
> * Make sure all tests pass and CI/CD pipelines pass.
> * Open pull request.

> * As a rule of thumb, changes are obvious fixes if they do not introduce any new functionality or creative thinking. As long as the change does not affect functionality, some likely examples include the following:
>> * Spelling / grammar fixes
>> * Typo correction, white space and formatting changes
>> * Comment clean up
>> * Bug fixes that change default return values or error codes stored in constants
>> * Adding logging messages or debugging output
>> * Changes to ‘metadata’ files like Gemfile, .gitignore, build scripts, etc.
>> * Moving source files from one directory or package to another

## How to report a bug
> * If you find a security vulnerability, do NOT open an issue. Email instead.

> *  When filing an issue, make sure to answer these five questions:
>> * What version of python are you using (python version)?
>> * What operating system and processor architecture are you using?
>> * What did you do?
>> * What did you expect to see?
>> * What did you see instead?
>> * General questions should go to discord instead.

## How to suggest a feature 
> * Pen an issue on our issues list on GitHub which describes the feature you would like to see, why you need it, and how it should work.

## Code review process
> * If all tests pass we will check code on every week Sa and Su day