# ChopStiX Trace Inspect

These are a set of tools which allow the inspection of traces generated by
ChopStiX. These go anywhere from visualizing the access patterns of successive
invocations to a function, to the clustering of the invocations to find similar
behaviors and choose adequate representatives for microbenchmark generation.

# Set up

```
virtualenv env
source env/bin/activate
pip install -r requirements.txt
```

# Tools
## cti-accesses

Plots the accessed pages of each invocation in a single scatter plot. The
x-axis corresponds to the invocation number, and the y-axis corresponds to the
page address. Thus, a point in coordinates (3, 0x1000) means the third
invocation accessed page 0x1000.

It optionally clusters the data first, and then colors the invocations of a
same cluster with the same color.

## cti-dbscan

Clusters the invocations using dbscan. There are two methods: clustering via
the trace file generated by ChopStiX, or clustering via the IPC of each
invocation gathered by riscv-perf. It generates a JSON file containing the
clustering information.

## cti-cluster-info

Reads a previously-generated JSON file containing clustering information and
displays various information. It can work in 3 modes:

- summary: Displays a summary of the clustering step. It shows information
such as the number of invocations, clusters, noise invocations, etc.
- representative: Picks random representative invocations of the overall
execution. It chooses one random invocation from each cluster, and all
invocations deemed to be noise points. Alternatively, it can be configured to
only output representatives from clusters or from noise points.
- invocation: It gives information regarding a particular invocation (i.e.
which cluster it is in, or if it is a noise point.)

## cti-trace-info

Displays information about a trace: subtrace count, invocation count and
distinct invocations (i.e. number of different access patterns).

## cti-histogram

Plots a histogram of various metrics from a trace. The histogram can show
the number of pages accessed by each invocation, the clustering distances
between all invocations, and the distance to the nearest neighbor
clustering-wise.
