#!/usr/bin/env sh
#
# ----------------------------------------------------------------------------
#
# Copyright 2019 IBM Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# ----------------------------------------------------------------------------
#

############################################################
# NAME        : parse_cmd.sh
# DESCRIPTION : Define command line arguments and help
#               for a ChopStiX command
# ARGUMENTS   :
#    in  : Input help file
#    out : Output header file
############################################################

in=$1
out=$2

cmd=$(basename "$in")
outdir=$(dirname "$out")

mkdir -p "$outdir"

{

cat << EndOfMessage
/************************************************************
 * Autogenerated header file for client/$cmd.c"
 ************************************************************/

#pragma once

namespace {

OptionDef opts_${cmd}[] = {
    { "help", false, "no" },
    { "version", false, "no" },
    { "verbose", false, "no" },
EndOfMessage

awk '
/^  -/{
    if (option) {
        print "    { \""option"\", "has_arg", "init" },"
    }
    gsub(/^-/,"",$1)
    has_arg="false"
    if ($1 ~ /^no-/) {
        gsub(/^no-/,"",$1)
        init="\"yes\""
    } else {
        init="\"no\""
    }
    option=$1
}

$2 ~ /^<.*>/ {
    gsub(/\.\./,"s",$2)
    gsub(/[<>]/,"",$2)
    has_arg="true"
    init="NULL"
}

/(default: )/ {
    gsub(/.*\(default: /,"",$0)
    gsub(/\).*/,"",$0)
    init="\""$0"\""
}

END {
    if (option) {
        print "    { \""option"\", "has_arg", "init" },"
    }
}
' "$in"

cat << EndOfMessage
    { NULL,      false,    NULL },
};

char help_${cmd}[] =
EndOfMessage

awk '{print "    \""$0"\\n\""}' "$in"

cat << EndOfMessage
    ;
}

int run_$cmd(int argc, char **argv);
EndOfMessage

} > "$out"

